/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.util.LambdaSafe;

class MeterRegistryConfigurer {
    private final ObjectProvider<MeterRegistryCustomizer<?>> customizers;
    private final ObjectProvider<MeterFilter> filters;
    private final ObjectProvider<MeterBinder> binders;
    private final boolean addToGlobalRegistry;

    MeterRegistryConfigurer(ObjectProvider<MeterRegistryCustomizer<?>> customizers, ObjectProvider<MeterFilter> filters, ObjectProvider<MeterBinder> binders, boolean addToGlobalRegistry) {
        this.customizers = customizers;
        this.filters = filters;
        this.binders = binders;
        this.addToGlobalRegistry = addToGlobalRegistry;
    }

    void configure(MeterRegistry registry) {
        this.customize(registry);
        this.addFilters(registry);
        this.addBinders(registry);
        if (this.addToGlobalRegistry && registry != Metrics.globalRegistry) {
            Metrics.addRegistry((MeterRegistry)registry);
        }
    }

    private void customize(MeterRegistry registry) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(MeterRegistryCustomizer.class, this.asOrderedList(this.customizers), (Object)registry, (Object[])new Object[0]).withLogger(MeterRegistryConfigurer.class)).invoke(customizer -> customizer.customize(registry));
    }

    private void addFilters(MeterRegistry registry) {
        this.filters.orderedStream().forEach(arg_0 -> ((MeterRegistry.Config)registry.config()).meterFilter(arg_0));
    }

    private void addBinders(MeterRegistry registry) {
        this.binders.orderedStream().forEach(binder -> binder.bindTo(registry));
    }

    private <T> List<T> asOrderedList(ObjectProvider<T> provider) {
        return provider.orderedStream().collect(Collectors.toList());
    }
}

