/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.neo4j;

import java.util.Map;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.neo4j.Neo4jHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jDataAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SessionFactory.class})
@ConditionalOnBean(value={SessionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="neo4j")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={Neo4jDataAutoConfiguration.class})
public class Neo4jHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<Neo4jHealthIndicator, SessionFactory> {
    private final Map<String, SessionFactory> sessionFactories;

    public Neo4jHealthIndicatorAutoConfiguration(Map<String, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
    }

    @Bean
    @ConditionalOnMissingBean(name={"neo4jHealthIndicator"})
    public HealthIndicator neo4jHealthIndicator() {
        return this.createHealthIndicator(this.sessionFactories);
    }
}

