/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry;

import java.util.Collection;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.EndpointCloudFoundryExtension;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointDiscoverer;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;

public class CloudFoundryWebEndpointDiscoverer
extends WebEndpointDiscoverer {
    public CloudFoundryWebEndpointDiscoverer(ApplicationContext applicationContext, ParameterValueMapper parameterValueMapper, EndpointMediaTypes endpointMediaTypes, List<PathMapper> endpointPathMappers, Collection<OperationInvokerAdvisor> invokerAdvisors, Collection<EndpointFilter<ExposableWebEndpoint>> filters) {
        super(applicationContext, parameterValueMapper, endpointMediaTypes, endpointPathMappers, invokerAdvisors, filters);
    }

    protected boolean isExtensionExposed(Object extensionBean) {
        return !this.isHealthEndpointExtension(extensionBean) || this.isCloudFoundryHealthEndpointExtension(extensionBean);
    }

    private boolean isHealthEndpointExtension(Object extensionBean) {
        AnnotationAttributes attributes = AnnotatedElementUtils.getMergedAnnotationAttributes(extensionBean.getClass(), EndpointWebExtension.class);
        Class endpoint = attributes != null ? attributes.getClass("endpoint") : null;
        return endpoint != null && HealthEndpoint.class.isAssignableFrom(endpoint);
    }

    private boolean isCloudFoundryHealthEndpointExtension(Object extensionBean) {
        return AnnotatedElementUtils.hasAnnotation(extensionBean.getClass(), EndpointCloudFoundryExtension.class);
    }
}

