/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointExtension;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

abstract class AbstractEndpointCondition
extends SpringBootCondition {
    private static final String ENABLED_BY_DEFAULT_KEY = "management.endpoints.enabled-by-default";
    private static final ConcurrentReferenceHashMap<Environment, Optional<Boolean>> enabledByDefaultCache = new ConcurrentReferenceHashMap();

    AbstractEndpointCondition() {
    }

    AnnotationAttributes getEndpointAttributes(Class<?> annotationClass, ConditionContext context, AnnotatedTypeMetadata metadata) {
        return this.getEndpointAttributes(this.getEndpointType(annotationClass, context, metadata));
    }

    protected ConditionOutcome getEnablementOutcome(ConditionContext context, AnnotatedTypeMetadata metadata, Class<? extends Annotation> annotationClass) {
        Environment environment = context.getEnvironment();
        AnnotationAttributes attributes = this.getEndpointAttributes(annotationClass, context, metadata);
        EndpointId id = EndpointId.of((String)attributes.getString("id"));
        String key = "management.endpoint." + id.toLowerCaseString() + ".enabled";
        Boolean userDefinedEnabled = (Boolean)environment.getProperty(key, Boolean.class);
        if (userDefinedEnabled != null) {
            return new ConditionOutcome(userDefinedEnabled.booleanValue(), ConditionMessage.forCondition(annotationClass, (Object[])new Object[0]).because("found property " + key + " with value " + userDefinedEnabled));
        }
        Boolean userDefinedDefault = this.isEnabledByDefault(environment);
        if (userDefinedDefault != null) {
            return new ConditionOutcome(userDefinedDefault.booleanValue(), ConditionMessage.forCondition(annotationClass, (Object[])new Object[0]).because("no property " + key + " found so using user defined default from " + ENABLED_BY_DEFAULT_KEY));
        }
        boolean endpointDefault = attributes.getBoolean("enableByDefault");
        return new ConditionOutcome(endpointDefault, ConditionMessage.forCondition(annotationClass, (Object[])new Object[0]).because("no property " + key + " found so using endpoint default"));
    }

    protected Class<?> getEndpointType(Class<?> annotationClass, ConditionContext context, AnnotatedTypeMetadata metadata) {
        Class target;
        Map attributes = metadata.getAnnotationAttributes(annotationClass.getName());
        if (attributes != null && attributes.containsKey("endpoint") && (target = (Class)attributes.get("endpoint")) != Void.class) {
            return target;
        }
        Assert.state((metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()) ? 1 : 0) != 0, (String)"EndpointCondition must be used on @Bean methods when the endpoint is not specified");
        MethodMetadata methodMetadata = (MethodMetadata)metadata;
        try {
            return ClassUtils.forName((String)methodMetadata.getReturnTypeName(), (ClassLoader)context.getClassLoader());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract endpoint id for " + methodMetadata.getDeclaringClassName() + "." + methodMetadata.getMethodName(), ex);
        }
    }

    protected AnnotationAttributes getEndpointAttributes(Class<?> type) {
        MergedAnnotations annotations = MergedAnnotations.from(type, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotation endpoint = annotations.get(Endpoint.class);
        if (endpoint.isPresent()) {
            return endpoint.asAnnotationAttributes(new MergedAnnotation.Adapt[0]);
        }
        MergedAnnotation extension = annotations.get(EndpointExtension.class);
        Assert.state((boolean)extension.isPresent(), (String)"No endpoint is specified and the return type of the @Bean method is neither an @Endpoint, nor an @EndpointExtension");
        return this.getEndpointAttributes(extension.getClass("endpoint"));
    }

    private Boolean isEnabledByDefault(Environment environment) {
        Optional<Object> enabledByDefault = (Optional<Object>)enabledByDefaultCache.get((Object)environment);
        if (enabledByDefault == null) {
            enabledByDefault = Optional.ofNullable(environment.getProperty(ENABLED_BY_DEFAULT_KEY, Boolean.class));
            enabledByDefaultCache.put((Object)environment, enabledByDefault);
        }
        return enabledByDefault.orElse(null);
    }
}

