/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collection;
import java.util.function.Predicate;
import org.springframework.boot.actuate.autoconfigure.health.HealthProperties;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.util.CollectionUtils;

class AutoConfiguredHealthEndpointGroup
implements HealthEndpointGroup {
    private final Predicate<String> members;
    private final StatusAggregator statusAggregator;
    private final HttpCodeStatusMapper httpCodeStatusMapper;
    private final HealthProperties.ShowDetails showDetails;
    private final Collection<String> roles;

    AutoConfiguredHealthEndpointGroup(Predicate<String> members, StatusAggregator statusAggregator, HttpCodeStatusMapper httpCodeStatusMapper, HealthProperties.ShowDetails showDetails, Collection<String> roles) {
        this.members = members;
        this.statusAggregator = statusAggregator;
        this.httpCodeStatusMapper = httpCodeStatusMapper;
        this.showDetails = showDetails;
        this.roles = roles;
    }

    public boolean isMember(String name) {
        return this.members.test(name);
    }

    public boolean includeDetails(SecurityContext securityContext) {
        HealthProperties.ShowDetails showDetails = this.showDetails;
        switch (showDetails) {
            case NEVER: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
            case WHEN_AUTHORIZED: {
                return this.isAuthorized(securityContext);
            }
        }
        throw new IllegalStateException("Unsupported ShowDetails value " + (Object)((Object)showDetails));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAuthorized(SecurityContext securityContext) {
        if (securityContext.getPrincipal() == null) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.roles)) return true;
        if (!this.roles.stream().anyMatch(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0))) return false;
        return true;
    }

    public StatusAggregator getStatusAggregator() {
        return this.statusAggregator;
    }

    public HttpCodeStatusMapper getHttpCodeStatusMapper() {
        return this.httpCodeStatusMapper;
    }
}

