/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorProperties;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
class LegacyHealthEndpointCompatibilityConfiguration {
    LegacyHealthEndpointCompatibilityConfiguration() {
    }

    @Bean
    @ConfigurationProperties(prefix="management.health.status")
    HealthIndicatorProperties healthIndicatorProperties(HealthEndpointProperties healthEndpointProperties) {
        return new HealthIndicatorProperties(healthEndpointProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    HealthAggregator healthAggregator(HealthIndicatorProperties healthIndicatorProperties) {
        OrderedHealthAggregator aggregator = new OrderedHealthAggregator();
        if (healthIndicatorProperties.getOrder() != null) {
            aggregator.setStatusOrder(healthIndicatorProperties.getOrder());
        }
        return aggregator;
    }

    @Bean
    @ConditionalOnMissingBean
    HealthStatusHttpMapper healthStatusHttpMapper(HealthIndicatorProperties healthIndicatorProperties) {
        HealthStatusHttpMapper mapper = new HealthStatusHttpMapper();
        if (healthIndicatorProperties.getHttpMapping() != null) {
            mapper.setStatusMapping(healthIndicatorProperties.getHttpMapping());
        }
        return mapper;
    }
}

