/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.SecurityResponse;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.servlet.AbstractWebMvcEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;

class CloudFoundryWebEndpointServletHandlerMapping
extends AbstractWebMvcEndpointHandlerMapping {
    private static final Log logger = LogFactory.getLog(CloudFoundryWebEndpointServletHandlerMapping.class);
    private final CloudFoundrySecurityInterceptor securityInterceptor;
    private final EndpointLinksResolver linksResolver;

    CloudFoundryWebEndpointServletHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, CloudFoundrySecurityInterceptor securityInterceptor, EndpointLinksResolver linksResolver) {
        super(endpointMapping, endpoints, endpointMediaTypes, corsConfiguration, true, WebMvcAutoConfiguration.pathPatternParser);
        this.securityInterceptor = securityInterceptor;
        this.linksResolver = linksResolver;
    }

    protected AbstractWebMvcEndpointHandlerMapping.ServletWebOperation wrapServletWebOperation(ExposableWebEndpoint endpoint, WebOperation operation, AbstractWebMvcEndpointHandlerMapping.ServletWebOperation servletWebOperation) {
        return new SecureServletWebOperation(servletWebOperation, this.securityInterceptor, endpoint.getEndpointId());
    }

    protected AbstractWebMvcEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return new CloudFoundryLinksHandler();
    }

    private static class SecureServletWebOperation
    implements AbstractWebMvcEndpointHandlerMapping.ServletWebOperation {
        private final AbstractWebMvcEndpointHandlerMapping.ServletWebOperation delegate;
        private final CloudFoundrySecurityInterceptor securityInterceptor;
        private final EndpointId endpointId;

        SecureServletWebOperation(AbstractWebMvcEndpointHandlerMapping.ServletWebOperation delegate, CloudFoundrySecurityInterceptor securityInterceptor, EndpointId endpointId) {
            this.delegate = delegate;
            this.securityInterceptor = securityInterceptor;
            this.endpointId = endpointId;
        }

        public Object handle(HttpServletRequest request, Map<String, String> body) {
            SecurityResponse securityResponse = this.securityInterceptor.preHandle(request, this.endpointId);
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                return new ResponseEntity((Object)securityResponse.getMessage(), securityResponse.getStatus());
            }
            return this.delegate.handle(request, body);
        }
    }

    class CloudFoundryLinksHandler
    implements AbstractWebMvcEndpointHandlerMapping.LinksHandler {
        CloudFoundryLinksHandler() {
        }

        @ResponseBody
        public Map<String, Map<String, Link>> links(HttpServletRequest request, HttpServletResponse response) {
            SecurityResponse securityResponse = CloudFoundryWebEndpointServletHandlerMapping.this.securityInterceptor.preHandle(request, null);
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                this.sendFailureResponse(response, securityResponse);
            }
            AccessLevel accessLevel = (AccessLevel)((Object)request.getAttribute("cloudFoundryAccessLevel"));
            Map<Object, Object> filteredLinks = new LinkedHashMap();
            if (accessLevel == null) {
                return Collections.singletonMap("_links", filteredLinks);
            }
            Map links = CloudFoundryWebEndpointServletHandlerMapping.this.linksResolver.resolveLinks(request.getRequestURL().toString());
            filteredLinks = links.entrySet().stream().filter(e -> ((String)e.getKey()).equals("self") || accessLevel.isAccessAllowed((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return Collections.singletonMap("_links", filteredLinks);
        }

        public String toString() {
            return "Actuator root web endpoint";
        }

        private void sendFailureResponse(HttpServletResponse response, SecurityResponse securityResponse) {
            try {
                response.sendError(securityResponse.getStatus().value(), securityResponse.getMessage());
            }
            catch (Exception ex) {
                logger.debug((Object)"Failed to send error response", (Throwable)ex);
            }
        }
    }
}

