/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collection;
import java.util.function.Predicate;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.actuate.health.AdditionalHealthEndpointPath;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.StatusAggregator;

class AutoConfiguredHealthEndpointGroup
implements HealthEndpointGroup {
    private final Predicate<String> members;
    private final StatusAggregator statusAggregator;
    private final HttpCodeStatusMapper httpCodeStatusMapper;
    private final Show showComponents;
    private final Show showDetails;
    private final Collection<String> roles;
    private final AdditionalHealthEndpointPath additionalPath;

    AutoConfiguredHealthEndpointGroup(Predicate<String> members, StatusAggregator statusAggregator, HttpCodeStatusMapper httpCodeStatusMapper, Show showComponents, Show showDetails, Collection<String> roles, AdditionalHealthEndpointPath additionalPath) {
        this.members = members;
        this.statusAggregator = statusAggregator;
        this.httpCodeStatusMapper = httpCodeStatusMapper;
        this.showComponents = showComponents;
        this.showDetails = showDetails;
        this.roles = roles;
        this.additionalPath = additionalPath;
    }

    public boolean isMember(String name) {
        return this.members.test(name);
    }

    public boolean showComponents(SecurityContext securityContext) {
        Show show = this.showComponents != null ? this.showComponents : this.showDetails;
        return show.isShown(securityContext, this.roles);
    }

    public boolean showDetails(SecurityContext securityContext) {
        return this.showDetails.isShown(securityContext, this.roles);
    }

    public StatusAggregator getStatusAggregator() {
        return this.statusAggregator;
    }

    public HttpCodeStatusMapper getHttpCodeStatusMapper() {
        return this.httpCodeStatusMapper;
    }

    public AdditionalHealthEndpointPath getAdditionalPath() {
        return this.additionalPath;
    }
}

