/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.HashSet;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.ManagementErrorEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.actuate.properties.ManagementServerProperties;
import org.springframework.boot.actuate.web.ErrorController;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
public class EndpointWebMvcChildContextConfiguration {
    @Value(value="${error.path:/error}")
    private String errorPath = "/error";

    @Bean
    public DispatcherServlet dispatcherServlet() {
        DispatcherServlet dispatcherServlet = new DispatcherServlet();
        dispatcherServlet.setDetectAllHandlerAdapters(false);
        dispatcherServlet.setDetectAllHandlerExceptionResolvers(false);
        dispatcherServlet.setDetectAllHandlerMappings(false);
        dispatcherServlet.setDetectAllViewResolvers(false);
        return dispatcherServlet;
    }

    @Bean
    public HandlerAdapter handlerAdapter(HttpMessageConverters converters) {
        RequestMappingHandlerAdapter adapter = new RequestMappingHandlerAdapter();
        adapter.setMessageConverters(converters.getConverters());
        return adapter;
    }

    @Bean
    public HandlerMapping handlerMapping(MvcEndpoints endpoints, ListableBeanFactory beanFactory) {
        HashSet<? extends MvcEndpoint> set = new HashSet<MvcEndpoint>(endpoints.getEndpoints());
        set.addAll(beanFactory.getBeansOfType(MvcEndpoint.class).values());
        EndpointHandlerMapping mapping = new EndpointHandlerMapping(set);
        mapping.setDetectHandlerMethodsInAncestorContexts(true);
        return mapping;
    }

    @Bean
    public ManagementErrorEndpoint errorEndpoint(ErrorController controller) {
        return new ManagementErrorEndpoint(this.errorPath, controller);
    }

    @Configuration
    @ConditionalOnClass(value={EnableWebSecurity.class, Filter.class})
    @ConditionalOnBean(name={"springSecurityFilterChain"}, search=SearchStrategy.PARENTS)
    public static class EndpointWebMvcChildContextSecurityConfiguration {
        @Bean
        public Filter springSecurityFilterChain(HierarchicalBeanFactory beanFactory) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            return (Filter)parent.getBean("springSecurityFilterChain", Filter.class);
        }
    }

    @Configuration
    protected static class ServerCustomization
    implements EmbeddedServletContainerCustomizer {
        @Value(value="${error.path:/error}")
        private String errorPath = "/error";
        @Autowired
        private ListableBeanFactory beanFactory;
        private ManagementServerProperties managementServerProperties;

        protected ServerCustomization() {
        }

        public void customize(ConfigurableEmbeddedServletContainerFactory factory) {
            if (this.managementServerProperties == null) {
                this.managementServerProperties = (ManagementServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ManagementServerProperties.class);
            }
            factory.setPort(this.managementServerProperties.getPort().intValue());
            factory.setAddress(this.managementServerProperties.getAddress());
            factory.setContextPath(this.managementServerProperties.getContextPath());
            factory.addErrorPages(new ErrorPage[]{new ErrorPage(this.errorPath)});
        }
    }
}

