/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.repository.InMemoryMetricRepository;
import org.springframework.boot.actuate.metrics.repository.MetricRepository;
import org.springframework.boot.actuate.metrics.writer.CodahaleMetricWriter;
import org.springframework.boot.actuate.metrics.writer.CompositeMetricWriter;
import org.springframework.boot.actuate.metrics.writer.DefaultCounterService;
import org.springframework.boot.actuate.metrics.writer.DefaultGaugeService;
import org.springframework.boot.actuate.metrics.writer.MessageChannelMetricWriter;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.boot.actuate.metrics.writer.MetricWriterMessageHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.ExecutorSubscribableChannel;

@Configuration
public class MetricRepositoryAutoConfiguration {
    @Autowired
    private MetricWriter writer;

    @Bean
    @ConditionalOnMissingBean
    public CounterService counterService() {
        return new DefaultCounterService(this.writer);
    }

    @Bean
    @ConditionalOnMissingBean
    public GaugeService gaugeService() {
        return new DefaultGaugeService(this.writer);
    }

    @Configuration
    @ConditionalOnClass(value={MetricRegistry.class})
    static class CodahaleMetricRegistryConfiguration {
        CodahaleMetricRegistryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MetricRegistry metricRegistry() {
            return new MetricRegistry();
        }

        @Bean
        public CodahaleMetricWriter codahaleMetricWriter(MetricRegistry metricRegistry) {
            return new CodahaleMetricWriter(metricRegistry);
        }

        @Bean
        @Primary
        @ConditionalOnMissingClass(name={"org.springframework.messaging.MessageChannel"})
        @ConditionalOnMissingBean(name={"primaryMetricWriter"})
        public MetricWriter primaryMetricWriter(List<MetricWriter> writers) {
            return new CompositeMetricWriter(writers);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MessageChannel.class})
    static class MetricsChannelConfiguration {
        @Autowired(required=false)
        @Qualifier(value="metricsExecutor")
        private final Executor executor = Executors.newSingleThreadExecutor();

        MetricsChannelConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"metricsChannel"})
        public SubscribableChannel metricsChannel() {
            return new ExecutorSubscribableChannel(this.executor);
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean(name={"primaryMetricWriter"})
        public MetricWriter primaryMetricWriter(@Qualifier(value="metricsChannel") SubscribableChannel channel, List<MetricWriter> writers) {
            CompositeMetricWriter observer = new CompositeMetricWriter(writers);
            channel.subscribe((MessageHandler)new MetricWriterMessageHandler(observer));
            return new MessageChannelMetricWriter((MessageChannel)channel);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={MetricRepository.class})
    static class MetricRepositoryConfiguration {
        MetricRepositoryConfiguration() {
        }

        @Bean
        public InMemoryMetricRepository metricRepository() {
            return new InMemoryMetricRepository();
        }
    }
}

