/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.web.ErrorController;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@ConfigurationProperties(name="error")
public class ManagementErrorEndpoint
implements MvcEndpoint {
    private final ErrorController controller;
    private final String path;

    public ManagementErrorEndpoint(String path, ErrorController controller) {
        Assert.notNull((Object)controller, (String)"Controller must not be null");
        this.path = path;
        this.controller = controller;
    }

    @RequestMapping
    @ResponseBody
    public Map<String, Object> invoke() {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        return this.controller.extract(attributes, false);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isSensitive() {
        return false;
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }
}

