/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.repository.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.MetricRepository;
import org.springframework.boot.actuate.metrics.repository.redis.RedisUtils;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

public class RedisMetricRepository
implements MetricRepository {
    private static final String DEFAULT_METRICS_PREFIX = "spring.metrics.";
    private String prefix = "spring.metrics.";
    private String keys = this.prefix + "keys";
    private final BoundZSetOperations<String, String> zSetOperations;
    private final RedisOperations<String, String> redisOperations;
    private final ValueOperations<String, Long> longOperations;

    public RedisMetricRepository(RedisConnectionFactory redisConnectionFactory) {
        Assert.notNull((Object)redisConnectionFactory, (String)"RedisConnectionFactory must not be null");
        this.redisOperations = RedisUtils.stringTemplate(redisConnectionFactory);
        RedisTemplate longRedisTemplate = RedisUtils.createRedisTemplate(redisConnectionFactory, Long.class);
        this.longOperations = longRedisTemplate.opsForValue();
        this.zSetOperations = this.redisOperations.boundZSetOps((Object)this.keys);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.keys = this.prefix + "keys";
    }

    @Override
    public Metric<?> findOne(String metricName) {
        String redisKey = this.keyFor(metricName);
        String raw = (String)this.redisOperations.opsForValue().get((Object)redisKey);
        if (raw != null) {
            return this.deserialize(redisKey, raw);
        }
        return null;
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        Set keys = this.zSetOperations.range(0L, -1L);
        Iterator keysIt = keys.iterator();
        ArrayList result = new ArrayList(keys.size());
        List values = this.redisOperations.opsForValue().multiGet((Collection)keys);
        for (String v : values) {
            result.add(this.deserialize((String)keysIt.next(), v));
        }
        return result;
    }

    @Override
    public long count() {
        return this.zSetOperations.size();
    }

    @Override
    public void increment(Delta<?> delta) {
        String name = delta.getName();
        String key = this.keyFor(name);
        this.trackMembership(key);
        this.longOperations.increment((Object)key, ((Number)delta.getValue()).longValue());
    }

    @Override
    public void set(Metric<?> value) {
        String raw = this.serialize(value);
        String name = value.getName();
        String key = this.keyFor(name);
        this.trackMembership(key);
        this.redisOperations.opsForValue().set((Object)key, (Object)raw);
    }

    @Override
    public void reset(String metricName) {
        String key = this.keyFor(metricName);
        if (this.zSetOperations.remove(new Object[]{key}) == 1L) {
            this.redisOperations.delete((Object)key);
        }
    }

    private Metric<?> deserialize(String redisKey, String v) {
        String[] vals = v.split("@");
        Double value = Double.valueOf(vals[0]);
        Date timestamp = vals.length > 1 ? new Date(Long.valueOf(vals[1])) : new Date();
        return new Metric<Double>(this.nameFor(redisKey), value, timestamp);
    }

    private String serialize(Metric<?> entity) {
        return String.valueOf(entity.getValue()) + "@" + entity.getTimestamp().getTime();
    }

    private String keyFor(String name) {
        return this.prefix + name;
    }

    private String nameFor(String redisKey) {
        Assert.state((redisKey != null && redisKey.startsWith(this.prefix) ? 1 : 0) != 0, (String)("Invalid key does not start with prefix: " + redisKey));
        return redisKey.substring(this.prefix.length());
    }

    private void trackMembership(String redisKey) {
        this.zSetOperations.add((Object)redisKey, 0.0);
    }
}

