/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.security;

import java.util.HashMap;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.web.authentication.switchuser.AuthenticationSwitchUserEvent;

public class AuthenticationAuditListener
implements ApplicationListener<AbstractAuthenticationEvent>,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void onApplicationEvent(AbstractAuthenticationEvent event) {
        if (event instanceof AbstractAuthenticationFailureEvent) {
            this.onAuthenticationFailureEvent((AbstractAuthenticationFailureEvent)event);
        } else if (event instanceof AuthenticationSwitchUserEvent) {
            this.onAuthenticationSwitchUserEvent((AuthenticationSwitchUserEvent)event);
        } else {
            this.onAuthenticationEvent(event);
        }
    }

    private void onAuthenticationFailureEvent(AbstractAuthenticationFailureEvent event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", ((Object)((Object)event.getException())).getClass().getName());
        data.put("message", event.getException().getMessage());
        this.publish(new AuditEvent(event.getAuthentication().getName(), "AUTHENTICATION_FAILURE", data));
    }

    private void onAuthenticationSwitchUserEvent(AuthenticationSwitchUserEvent event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (event.getAuthentication().getDetails() != null) {
            data.put("details", event.getAuthentication().getDetails());
        }
        data.put("target", event.getTargetUser().getUsername());
        this.publish(new AuditEvent(event.getAuthentication().getName(), "AUTHENTICATION_SWITCH", data));
    }

    private void onAuthenticationEvent(AbstractAuthenticationEvent event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (event.getAuthentication().getDetails() != null) {
            data.put("details", event.getAuthentication().getDetails());
        }
        this.publish(new AuditEvent(event.getAuthentication().getName(), "AUTHENTICATION_SUCCESS", data));
    }

    private void publish(AuditEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new AuditApplicationEvent(event));
        }
    }
}

