/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(name="endpoints.info", ignoreUnknownFields=false)
public class InfoEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private final Map<String, ? extends Object> info;

    public InfoEndpoint(Map<String, ? extends Object> info) {
        super("info", false, true);
        Assert.notNull(info, (String)"Info must not be null");
        this.info = info;
    }

    @Override
    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>(this.info);
        info.putAll(this.getAdditionalInfo());
        return info;
    }

    protected Map<String, Object> getAdditionalInfo() {
        return Collections.emptyMap();
    }
}

