/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import com.mongodb.CommandResult;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.Assert;

public class MongoHealthIndicator
extends AbstractHealthIndicator {
    private final MongoTemplate mongoTemplate;

    public MongoHealthIndicator(MongoTemplate mongoTemplate) {
        Assert.notNull((Object)mongoTemplate, (String)"MongoTemplate must not be null");
        this.mongoTemplate = mongoTemplate;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        CommandResult result = this.mongoTemplate.executeCommand("{ serverStatus: 1 }");
        builder.up().withDetail("version", result.getString("version"));
    }
}

