/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="endpoints.configprops", ignoreUnknownFields=false)
public class ConfigurationPropertiesReportEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements ApplicationContextAware {
    private static final String CGLIB_FILTER_ID = "cglibFilter";
    private String[] keysToSanitize = new String[]{"password", "secret", "key"};
    private ApplicationContext context;
    private ConfigurationBeanFactoryMetaData beanFactoryMetaData;

    public ConfigurationPropertiesReportEndpoint() {
        super("configprops");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setConfigurationBeanFactoryMetaData(ConfigurationBeanFactoryMetaData beanFactoryMetaData) {
        this.beanFactoryMetaData = beanFactoryMetaData;
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        Assert.notNull((Object)keysToSanitize, (String)"KeysToSanitize must not be null");
        this.keysToSanitize = keysToSanitize;
    }

    @Override
    public Map<String, Object> invoke() {
        return this.extract(this.context);
    }

    protected Map<String, Object> extract(ApplicationContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap beans = new HashMap(context.getBeansWithAnnotation(ConfigurationProperties.class));
        if (this.beanFactoryMetaData != null) {
            beans.putAll(this.beanFactoryMetaData.getBeansWithFactoryAnnotation(ConfigurationProperties.class));
        }
        ObjectMapper mapper = new ObjectMapper();
        this.configureObjectMapper(mapper);
        for (Map.Entry entry : beans.entrySet()) {
            String beanName = (String)entry.getKey();
            Object bean = entry.getValue();
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("prefix", this.extractPrefix(context, beanName, bean));
            root.put("properties", this.sanitize((Map)mapper.convertValue(bean, Map.class)));
            result.put(beanName, root);
        }
        if (context.getParent() != null) {
            result.put("parent", this.extract(context.getParent()));
        }
        return result;
    }

    protected void configureObjectMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.applyCglibFilters(mapper);
        this.applySerializationModifier(mapper);
    }

    private void applySerializationModifier(ObjectMapper mapper) {
        SerializerFactory factory = BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new GenericSerializerModifier());
        mapper.setSerializerFactory(factory);
    }

    private void applyCglibFilters(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new CglibAnnotationIntrospector());
        mapper.setFilters((FilterProvider)new SimpleFilterProvider().addFilter(CGLIB_FILTER_ID, (SimpleBeanPropertyFilter)new CglibBeanPropertyFilter()));
    }

    private String extractPrefix(ApplicationContext context, String beanName, Object bean) {
        ConfigurationProperties override;
        ConfigurationProperties annotation = (ConfigurationProperties)context.findAnnotationOnBean(beanName, ConfigurationProperties.class);
        if (this.beanFactoryMetaData != null && (override = (ConfigurationProperties)this.beanFactoryMetaData.findFactoryAnnotation(beanName, ConfigurationProperties.class)) != null) {
            annotation = override;
        }
        return StringUtils.hasLength((String)annotation.value()) ? annotation.value() : annotation.prefix();
    }

    private Map<String, Object> sanitize(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                map.put(entry.getKey(), this.sanitize((Map)entry.getValue()));
                continue;
            }
            map.put(entry.getKey(), this.sanitize(entry.getKey(), entry.getValue()));
        }
        return map;
    }

    private Object sanitize(String name, Object object) {
        for (String keyToSanitize : this.keysToSanitize) {
            if (!name.toLowerCase().endsWith(keyToSanitize)) continue;
            return object == null ? null : "******";
        }
        return object;
    }

    protected static class GenericSerializerModifier
    extends BeanSerializerModifier {
        private ConversionService conversionService = new DefaultConversionService();

        protected GenericSerializerModifier() {
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
            for (BeanPropertyWriter writer : beanProperties) {
                AnnotatedMethod setter = beanDesc.findMethod("set" + StringUtils.capitalize((String)writer.getName()), new Class[]{writer.getPropertyType()});
                if (setter == null || !this.conversionService.canConvert(String.class, writer.getPropertyType())) continue;
                result.add(writer);
            }
            return result;
        }
    }

    private static class CglibBeanPropertyFilter
    extends SimpleBeanPropertyFilter {
        private CglibBeanPropertyFilter() {
        }

        protected boolean include(BeanPropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        protected boolean include(PropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        private boolean include(String name) {
            return !name.startsWith("$$");
        }
    }

    private static class CglibAnnotationIntrospector
    extends JacksonAnnotationIntrospector {
        private CglibAnnotationIntrospector() {
        }

        public Object findFilterId(Annotated a) {
            Object id = super.findFilterId(a);
            if (id == null) {
                id = ConfigurationPropertiesReportEndpoint.CGLIB_FILTER_ID;
            }
            return id;
        }
    }
}

