/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class VanillaPublicMetrics
implements PublicMetrics {
    private final MetricReader reader;
    private long timestamp;

    public VanillaPublicMetrics(MetricReader reader) {
        Assert.notNull((Object)reader, (String)"MetricReader must not be null");
        this.reader = reader;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public Collection<Metric<?>> metrics() {
        LinkedHashSet result = new LinkedHashSet();
        for (Metric<?> metric : this.reader.findAll()) {
            result.add(metric);
        }
        this.addMetrics(result);
        this.addHeapMetrics(result);
        this.addThreadMetrics(result);
        this.addClassLoadingMetrics(result);
        this.addGarbageCollecitonMetrics(result);
        return result;
    }

    protected void addMetrics(Collection<Metric<?>> result) {
        result.add(new Metric<Long>("mem", new Long(Runtime.getRuntime().totalMemory()) / 1024L));
        result.add(new Metric<Long>("mem.free", new Long(Runtime.getRuntime().freeMemory()) / 1024L));
        result.add(new Metric<Integer>("processors", Runtime.getRuntime().availableProcessors()));
        result.add(new Metric<Long>("uptime", new Long(ManagementFactory.getRuntimeMXBean().getUptime())));
        result.add(new Metric<Long>("instance.uptime", System.currentTimeMillis() - this.timestamp));
    }

    protected void addHeapMetrics(Collection<Metric<?>> result) {
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        result.add(new Metric<Long>("heap.committed", memoryUsage.getCommitted() / 1024L));
        result.add(new Metric<Long>("heap.init", memoryUsage.getInit() / 1024L));
        result.add(new Metric<Long>("heap.used", memoryUsage.getUsed() / 1024L));
        result.add(new Metric<Long>("heap", memoryUsage.getMax() / 1024L));
    }

    protected void addThreadMetrics(Collection<Metric<?>> result) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        result.add(new Metric<Long>("threads.peak", new Long(threadMxBean.getPeakThreadCount())));
        result.add(new Metric<Long>("threads.daemon", new Long(threadMxBean.getDaemonThreadCount())));
        result.add(new Metric<Long>("threads", new Long(threadMxBean.getThreadCount())));
    }

    protected void addClassLoadingMetrics(Collection<Metric<?>> result) {
        ClassLoadingMXBean classLoadingMxBean = ManagementFactory.getClassLoadingMXBean();
        result.add(new Metric<Long>("classes", new Long(classLoadingMxBean.getLoadedClassCount())));
        result.add(new Metric<Long>("classes.loaded", new Long(classLoadingMxBean.getTotalLoadedClassCount())));
        result.add(new Metric<Long>("classes.unloaded", new Long(classLoadingMxBean.getUnloadedClassCount())));
    }

    protected void addGarbageCollecitonMetrics(Collection<Metric<?>> result) {
        List<GarbageCollectorMXBean> garbageCollectorMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (int i = 0; i < garbageCollectorMxBeans.size(); ++i) {
            GarbageCollectorMXBean garbageCollectorMXBean = garbageCollectorMxBeans.get(i);
            String name = this.beautifyGcName(garbageCollectorMXBean.getName());
            result.add(new Metric<Long>("gc." + name + ".count", new Long(garbageCollectorMXBean.getCollectionCount())));
            result.add(new Metric<Long>("gc." + name + ".time", new Long(garbageCollectorMXBean.getCollectionTime())));
        }
    }

    private String beautifyGcName(String name) {
        return StringUtils.replace((String)name, (String)" ", (String)"_").toLowerCase();
    }
}

