/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.jmx.DataEndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.ShutdownEndpointMBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.jmx.export.MBeanExportException;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ObjectUtils;

public class EndpointMBeanExporter
extends MBeanExporter
implements SmartLifecycle,
BeanFactoryAware,
ApplicationContextAware {
    public static final String DEFAULT_DOMAIN = "org.springframework.boot";
    private static Log logger = LogFactory.getLog(EndpointMBeanExporter.class);
    private final AnnotationJmxAttributeSource attributeSource = new AnnotationJmxAttributeSource();
    private final MetadataMBeanInfoAssembler assembler = new MetadataMBeanInfoAssembler((JmxAttributeSource)this.attributeSource);
    private final MetadataNamingStrategy defaultNamingStrategy = new MetadataNamingStrategy((JmxAttributeSource)this.attributeSource);
    private final Set<Endpoint<?>> registeredEndpoints = new HashSet();
    private volatile boolean autoStartup = true;
    private volatile int phase = 0;
    private volatile boolean running = false;
    private final ReentrantLock lifecycleLock = new ReentrantLock();
    private ApplicationContext applicationContext;
    private ListableBeanFactory beanFactory;
    private String domain = "org.springframework.boot";
    private boolean ensureUniqueRuntimeObjectNames = false;
    private Properties objectNameStaticProperties = new Properties();

    public EndpointMBeanExporter() {
        this.setAutodetect(false);
        this.setNamingStrategy((ObjectNamingStrategy)this.defaultNamingStrategy);
        this.setAssembler((MBeanInfoAssembler)this.assembler);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        } else {
            logger.info((Object)"EndpointMBeanExporter not running in a ListableBeanFactory: autodetection of Endpoints not available.");
        }
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEnsureUniqueRuntimeObjectNames(boolean ensureUniqueRuntimeObjectNames) {
        super.setEnsureUniqueRuntimeObjectNames(ensureUniqueRuntimeObjectNames);
        this.ensureUniqueRuntimeObjectNames = ensureUniqueRuntimeObjectNames;
    }

    public void setObjectNameStaticProperties(Properties objectNameStaticProperties) {
        this.objectNameStaticProperties = objectNameStaticProperties;
    }

    protected void doStart() {
        this.locateAndRegisterEndpoints();
    }

    protected void locateAndRegisterEndpoints() {
        Map endpoints = this.beanFactory.getBeansOfType(Endpoint.class);
        for (Map.Entry endpointEntry : endpoints.entrySet()) {
            if (this.registeredEndpoints.contains(endpointEntry.getValue())) continue;
            this.registerEndpoint((String)endpointEntry.getKey(), (Endpoint)endpointEntry.getValue());
            this.registeredEndpoints.add((Endpoint<?>)endpointEntry.getValue());
        }
    }

    protected void registerEndpoint(String beanName, Endpoint<?> endpoint) {
        try {
            this.registerBeanNameOrInstance(this.getEndpointMBean(beanName, endpoint), beanName);
        }
        catch (MBeanExportException ex) {
            logger.error((Object)("Could not register MBean for endpoint [" + beanName + "]"), (Throwable)ex);
        }
    }

    protected EndpointMBean getEndpointMBean(String beanName, Endpoint<?> endpoint) {
        if (endpoint instanceof ShutdownEndpoint) {
            return new ShutdownEndpointMBean(beanName, endpoint);
        }
        return new DataEndpointMBean(beanName, endpoint);
    }

    protected ObjectName getObjectName(Object bean, String beanKey) throws MalformedObjectNameException {
        if (bean instanceof SelfNaming) {
            return ((SelfNaming)bean).getObjectName();
        }
        if (bean instanceof EndpointMBean) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.domain);
            builder.append(":type=Endpoint");
            builder.append(",name=" + beanKey);
            if (this.parentContextContainsSameBean(this.applicationContext, beanKey)) {
                builder.append(",context=" + ObjectUtils.getIdentityHexString((Object)this.applicationContext));
            }
            if (this.ensureUniqueRuntimeObjectNames) {
                builder.append(",identity=" + ObjectUtils.getIdentityHexString(((EndpointMBean)bean).getEndpoint()));
            }
            builder.append(this.getStaticNames());
            return ObjectNameManager.getInstance((String)builder.toString());
        }
        return this.defaultNamingStrategy.getObjectName(bean, beanKey);
    }

    private boolean parentContextContainsSameBean(ApplicationContext applicationContext, String beanKey) {
        if (applicationContext.getParent() != null) {
            try {
                this.applicationContext.getParent().getBean(beanKey, Endpoint.class);
                return true;
            }
            catch (BeansException ex) {
                return this.parentContextContainsSameBean(applicationContext.getParent(), beanKey);
            }
        }
        return false;
    }

    private String getStaticNames() {
        if (this.objectNameStaticProperties.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object key : this.objectNameStaticProperties.keySet()) {
            builder.append("," + key + "=" + this.objectNameStaticProperties.get(key));
        }
        return builder.toString();
    }

    public final int getPhase() {
        return this.phase;
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.running = false;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }
}

