/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class HealthMvcEndpoint
extends EndpointMvcAdapter {
    private Map<String, HttpStatus> statusMapping = new HashMap<String, HttpStatus>();

    public HealthMvcEndpoint(HealthEndpoint delegate) {
        super(delegate);
        this.setupDefaultStatusMapping();
    }

    private void setupDefaultStatusMapping() {
        this.addStatusMapping(Status.DOWN, HttpStatus.SERVICE_UNAVAILABLE);
        this.addStatusMapping(Status.OUT_OF_SERVICE, HttpStatus.SERVICE_UNAVAILABLE);
    }

    public void setStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping = new HashMap<String, HttpStatus>(statusMapping);
    }

    public void addStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping.putAll(statusMapping);
    }

    public void addStatusMapping(Status status, HttpStatus httpStatus) {
        Assert.notNull((Object)status, (String)"Status must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.addStatusMapping(status.getCode(), httpStatus);
    }

    public void addStatusMapping(String statusCode, HttpStatus httpStatus) {
        Assert.notNull((Object)statusCode, (String)"StatusCode must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.statusMapping.put(statusCode, httpStatus);
    }

    @Override
    @RequestMapping
    @ResponseBody
    public Object invoke() {
        if (!this.getDelegate().isEnabled()) {
            return new ResponseEntity(Collections.singletonMap("message", "This endpoint is disabled"), HttpStatus.NOT_FOUND);
        }
        Health health = (Health)this.getDelegate().invoke();
        Status status = health.getStatus();
        if (this.statusMapping.containsKey(status.getCode())) {
            return new ResponseEntity((Object)health, this.statusMapping.get(status.getCode()));
        }
        return health;
    }
}

