/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.actuate.endpoint.Sanitizer;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="endpoints.configprops", ignoreUnknownFields=false)
public class ConfigurationPropertiesReportEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements ApplicationContextAware {
    private static final String CGLIB_FILTER_ID = "cglibFilter";
    private static final Log logger = LogFactory.getLog(ConfigurationPropertiesReportEndpoint.class);
    private final Sanitizer sanitizer = new Sanitizer();
    private ApplicationContext context;
    private ConfigurationPropertiesMetaData metadata;
    private String metadataLocations = "classpath:*/META-INF/*spring-configuration-metadata.json";

    public ConfigurationPropertiesReportEndpoint() {
        super("configprops");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        this.sanitizer.setKeysToSanitize(keysToSanitize);
    }

    public void setMetadataLocations(String metadataLocations) {
        this.metadataLocations = metadataLocations;
    }

    @Override
    public Map<String, Object> invoke() {
        return this.extract(this.context);
    }

    protected Map<String, Object> extract(ApplicationContext context) {
        ObjectMapper mapper = new ObjectMapper();
        this.configureObjectMapper(mapper);
        return this.extract(context, mapper);
    }

    private Map<String, Object> extract(ApplicationContext context, ObjectMapper mapper) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConfigurationBeanFactoryMetaData beanFactoryMetaData = this.getBeanFactoryMetaData(context);
        Map<String, Object> beans = this.getConfigurationPropertiesBeans(context, beanFactoryMetaData);
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            String beanName = entry.getKey();
            Object bean = entry.getValue();
            HashMap<String, Object> root = new HashMap<String, Object>();
            String prefix = this.extractPrefix(context, beanFactoryMetaData, beanName, bean);
            root.put("prefix", prefix);
            root.put("properties", this.sanitize(this.safeSerialize(mapper, bean, prefix)));
            result.put(beanName, root);
        }
        if (context.getParent() != null) {
            result.put("parent", this.extract(context.getParent(), mapper));
        }
        return result;
    }

    private ConfigurationBeanFactoryMetaData getBeanFactoryMetaData(ApplicationContext context) {
        Map beans = context.getBeansOfType(ConfigurationBeanFactoryMetaData.class);
        if (beans.size() == 1) {
            return (ConfigurationBeanFactoryMetaData)beans.values().iterator().next();
        }
        return null;
    }

    private Map<String, Object> getConfigurationPropertiesBeans(ApplicationContext context, ConfigurationBeanFactoryMetaData beanFactoryMetaData) {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.putAll(context.getBeansWithAnnotation(ConfigurationProperties.class));
        if (beanFactoryMetaData != null) {
            beans.putAll(beanFactoryMetaData.getBeansWithFactoryAnnotation(ConfigurationProperties.class));
        }
        return beans;
    }

    private Map<String, Object> safeSerialize(ObjectMapper mapper, Object bean, String prefix) {
        if (this.metadata == null) {
            this.metadata = new ConfigurationPropertiesMetaData(this.metadataLocations);
        }
        try {
            HashMap<String, Object> result = new HashMap<String, Object>((Map)mapper.convertValue(this.metadata.extractMap(bean, prefix), Map.class));
            return result;
        }
        catch (Exception ex) {
            return new HashMap<String, Object>(Collections.singletonMap("error", "Cannot serialize '" + prefix + "'"));
        }
    }

    protected void configureObjectMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.applyCglibFilters(mapper);
        this.applySerializationModifier(mapper);
    }

    private void applySerializationModifier(ObjectMapper mapper) {
        SerializerFactory factory = BeanSerializerFactory.instance.withSerializerModifier((BeanSerializerModifier)new GenericSerializerModifier());
        mapper.setSerializerFactory(factory);
    }

    private void applyCglibFilters(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new CglibAnnotationIntrospector());
        mapper.setFilters((FilterProvider)new SimpleFilterProvider().addFilter(CGLIB_FILTER_ID, (SimpleBeanPropertyFilter)new CglibBeanPropertyFilter()));
    }

    private String extractPrefix(ApplicationContext context, ConfigurationBeanFactoryMetaData beanFactoryMetaData, String beanName, Object bean) {
        ConfigurationProperties override;
        ConfigurationProperties annotation = (ConfigurationProperties)context.findAnnotationOnBean(beanName, ConfigurationProperties.class);
        if (beanFactoryMetaData != null && (override = (ConfigurationProperties)beanFactoryMetaData.findFactoryAnnotation(beanName, ConfigurationProperties.class)) != null) {
            annotation = override;
        }
        return StringUtils.hasLength((String)annotation.value()) ? annotation.value() : annotation.prefix();
    }

    private Map<String, Object> sanitize(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                map.put(key, this.sanitize((Map)value));
                continue;
            }
            map.put(key, this.sanitizer.sanitize(key, value));
        }
        return map;
    }

    protected static class ConfigurationPropertiesMetaData {
        private final String metadataLocations;
        private final Map<String, Set<String>> matched = new HashMap<String, Set<String>>();
        private Set<String> keys = null;

        public ConfigurationPropertiesMetaData(String metadataLocations) {
            this.metadataLocations = metadataLocations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean matches(String prefix) {
            if (this.matched.containsKey(prefix)) {
                return this.matchesInternal(prefix);
            }
            Map<String, Set<String>> map = this.matched;
            synchronized (map) {
                if (this.matched.containsKey(prefix)) {
                    return this.matchesInternal(prefix);
                }
                this.matched.put(prefix, this.findKeys(prefix));
            }
            return this.matchesInternal(prefix);
        }

        private boolean matchesInternal(String prefix) {
            return this.matched.get(prefix) != null;
        }

        private Set<String> findKeys(String prefix) {
            HashSet<String> keys = new HashSet<String>();
            for (String key : this.getKeys()) {
                if (key.length() <= prefix.length() || !key.startsWith(prefix) || !".".equals(key.substring(prefix.length(), prefix.length() + 1))) continue;
                keys.add(key.substring(prefix.length() + 1));
            }
            return keys.isEmpty() ? null : keys;
        }

        private Set<String> getKeys() {
            if (this.keys != null) {
                return this.keys;
            }
            this.keys = new HashSet<String>();
            try {
                Resource[] resources;
                ObjectMapper mapper = new ObjectMapper();
                for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources(this.metadataLocations)) {
                    this.addKeys(mapper, resource);
                }
            }
            catch (IOException ex) {
                logger.warn((Object)"Could not deserialize config properties metadata", (Throwable)ex);
            }
            return this.keys;
        }

        private void addKeys(ObjectMapper mapper, Resource resource) throws IOException, JsonParseException, JsonMappingException {
            InputStream inputStream = resource.getInputStream();
            Map map = (Map)mapper.readValue(inputStream, Map.class);
            Collection metadata = (Collection)map.get("properties");
            for (Map value : metadata) {
                try {
                    if (!value.containsKey("type")) continue;
                    this.keys.add((String)value.get("name"));
                }
                catch (Exception ex) {
                    logger.warn((Object)"Could not parse config properties metadata", (Throwable)ex);
                }
            }
        }

        public Object extractMap(Object bean, String prefix) {
            if (!this.matches(prefix)) {
                return bean;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : this.matched.get(prefix)) {
                this.addProperty(bean, key, map);
            }
            return map;
        }

        private void addProperty(Object bean, String key, Map<String, Object> map) {
            String prefix = key.contains(".") ? StringUtils.split((String)key, (String)".")[0] : key;
            String suffix = key.length() > prefix.length() ? key.substring(prefix.length() + 1) : null;
            String property = prefix;
            if (bean instanceof Map) {
                Map value = (Map)bean;
                bean = new MapHolder(value);
                property = "map[" + property + "]";
            }
            BeanWrapperImpl wrapper = new BeanWrapperImpl(bean);
            try {
                Object value = wrapper.getPropertyValue(property);
                if (value instanceof Map) {
                    HashMap<String, Object> nested = new HashMap<String, Object>();
                    map.put(prefix, nested);
                    if (suffix != null) {
                        this.addProperty(value, suffix, nested);
                    }
                } else {
                    map.put(prefix, value);
                }
            }
            catch (Exception ex) {
                logger.debug((Object)("Could not parse config properties metadata '" + key + "': " + ex.getMessage()));
            }
        }

        protected static class MapHolder {
            Map<String, Object> map = new HashMap<String, Object>();

            public MapHolder(Map<String, Object> bean) {
                this.map.putAll(bean);
            }

            public Map<String, Object> getMap() {
                return this.map;
            }

            public void setMap(Map<String, Object> map) {
                this.map = map;
            }
        }
    }

    protected static class GenericSerializerModifier
    extends BeanSerializerModifier {
        protected GenericSerializerModifier() {
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
            for (BeanPropertyWriter writer : beanProperties) {
                boolean readable = this.isReadable(beanDesc, writer);
                if (!readable) continue;
                result.add(writer);
            }
            return result;
        }

        private boolean isReadable(BeanDescription beanDesc, BeanPropertyWriter writer) {
            String parentType = beanDesc.getType().getRawClass().getName();
            String type = writer.getPropertyType().getName();
            AnnotatedMethod setter = beanDesc.findMethod("set" + StringUtils.capitalize((String)writer.getName()), new Class[]{writer.getPropertyType()});
            return setter != null || ClassUtils.getPackageName((String)parentType).equals(ClassUtils.getPackageName((String)type));
        }
    }

    private static class CglibBeanPropertyFilter
    extends SimpleBeanPropertyFilter {
        private CglibBeanPropertyFilter() {
        }

        protected boolean include(BeanPropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        protected boolean include(PropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        private boolean include(String name) {
            return !name.startsWith("$$");
        }
    }

    private static class CglibAnnotationIntrospector
    extends JacksonAnnotationIntrospector {
        private CglibAnnotationIntrospector() {
        }

        public Object findFilterId(Annotated a) {
            Object id = super.findFilterId(a);
            if (id == null) {
                id = ConfigurationPropertiesReportEndpoint.CGLIB_FILTER_ID;
            }
            return id;
        }
    }
}

