/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.system;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ApplicationPid;
import org.springframework.boot.actuate.system.SystemProperties;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;

public class ApplicationPidFileWriter
implements ApplicationListener<SpringApplicationEvent>,
Ordered {
    private static final Log logger = LogFactory.getLog(ApplicationPidFileWriter.class);
    private static final String DEFAULT_FILE_NAME = "application.pid";
    private static final String[] SYSTEM_PROPERTY_VARIABLES = new String[]{"PIDFILE", "pidfile"};
    private static final String SPRING_PROPERTY = "spring.pidfile";
    private static final AtomicBoolean created = new AtomicBoolean(false);
    private int order = -2147483635;
    private final File file;
    private Class<? extends SpringApplicationEvent> triggerEventType = ApplicationPreparedEvent.class;

    public ApplicationPidFileWriter() {
        this(new File(DEFAULT_FILE_NAME));
    }

    public ApplicationPidFileWriter(String filename) {
        this(new File(filename));
    }

    public ApplicationPidFileWriter(File file) {
        Assert.notNull((Object)file, (String)"File must not be null");
        this.file = file;
    }

    public void setTriggerEventType(Class<? extends SpringApplicationEvent> triggerEventType) {
        Assert.notNull(triggerEventType, (String)"Trigger event type must not be null");
        this.triggerEventType = triggerEventType;
    }

    public void onApplicationEvent(SpringApplicationEvent event) {
        if (this.triggerEventType.isInstance(event) && created.compareAndSet(false, true)) {
            try {
                this.writePidFile(event);
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("Cannot create pid file %s", this.file));
            }
        }
    }

    private void writePidFile(SpringApplicationEvent event) throws IOException {
        File pidFile = this.file;
        String override = SystemProperties.get(SYSTEM_PROPERTY_VARIABLES);
        if (override != null) {
            pidFile = new File(override);
        } else {
            Environment environment = this.getEnvironment(event);
            if (environment != null && (override = new RelaxedPropertyResolver((PropertyResolver)environment).getProperty(SPRING_PROPERTY)) != null) {
                pidFile = new File(override);
            }
        }
        new ApplicationPid().write(pidFile);
        pidFile.deleteOnExit();
    }

    private Environment getEnvironment(SpringApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            return ((ApplicationEnvironmentPreparedEvent)event).getEnvironment();
        }
        if (event instanceof ApplicationPreparedEvent) {
            return ((ApplicationPreparedEvent)event).getApplicationContext().getEnvironment();
        }
        return null;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    static void reset() {
        created.set(false);
    }
}

