/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.Collection;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.sql.DataSource;
import org.apache.solr.client.solrj.SolrServer;
import org.elasticsearch.client.Client;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnablednHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.HealthIndicatorAutoConfigurationProperties;
import org.springframework.boot.actuate.health.ApplicationHealthIndicator;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.DataSourceHealthIndicator;
import org.springframework.boot.actuate.health.DiskSpaceHealthIndicator;
import org.springframework.boot.actuate.health.DiskSpaceHealthIndicatorProperties;
import org.springframework.boot.actuate.health.ElasticsearchHealthIndicator;
import org.springframework.boot.actuate.health.ElasticsearchHealthIndicatorProperties;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.JmsHealthIndicator;
import org.springframework.boot.actuate.health.MailHealthIndicator;
import org.springframework.boot.actuate.health.MongoHealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.RabbitHealthIndicator;
import org.springframework.boot.actuate.health.RedisHealthIndicator;
import org.springframework.boot.actuate.health.SolrHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProviders;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, RedisAutoConfiguration.class, RabbitAutoConfiguration.class, SolrAutoConfiguration.class, MailSenderAutoConfiguration.class, JmsAutoConfiguration.class, ElasticsearchAutoConfiguration.class})
@EnableConfigurationProperties(value={HealthIndicatorAutoConfigurationProperties.class})
public class HealthIndicatorAutoConfiguration {
    @Autowired
    private HealthIndicatorAutoConfigurationProperties configurationProperties = new HealthIndicatorAutoConfigurationProperties();

    @Bean
    @ConditionalOnMissingBean(value={HealthAggregator.class})
    public OrderedHealthAggregator healthAggregator() {
        OrderedHealthAggregator healthAggregator = new OrderedHealthAggregator();
        if (this.configurationProperties.getOrder() != null) {
            healthAggregator.setStatusOrder(this.configurationProperties.getOrder());
        }
        return healthAggregator;
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthIndicator.class})
    public ApplicationHealthIndicator applicationHealthIndicator() {
        return new ApplicationHealthIndicator();
    }

    @Configuration
    @ConditionalOnBean(value={Client.class})
    @ConditionalOnEnablednHealthIndicator(value="elasticsearch")
    @EnableConfigurationProperties(value={ElasticsearchHealthIndicatorProperties.class})
    public static class ElasticsearchHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<ElasticsearchHealthIndicator, Client> {
        @Autowired
        private Map<String, Client> clients;
        @Autowired
        private ElasticsearchHealthIndicatorProperties properties;

        @Bean
        @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator"})
        public HealthIndicator elasticsearchHealthIndicator() {
            return this.createHealthIndicator(this.clients);
        }

        @Override
        protected ElasticsearchHealthIndicator createHealthIndicator(Client client) {
            return new ElasticsearchHealthIndicator(client, this.properties);
        }
    }

    @Configuration
    @ConditionalOnBean(value={ConnectionFactory.class})
    @ConditionalOnEnablednHealthIndicator(value="jms")
    public static class JmsHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<JmsHealthIndicator, ConnectionFactory> {
        @Autowired(required=false)
        private Map<String, ConnectionFactory> connectionFactories;

        @Bean
        @ConditionalOnMissingBean(name={"jmsHealthIndicator"})
        public HealthIndicator jmsHealthIndicator() {
            return this.createHealthIndicator(this.connectionFactories);
        }
    }

    @Configuration
    @ConditionalOnBean(value={JavaMailSenderImpl.class})
    @ConditionalOnEnablednHealthIndicator(value="mail")
    public static class MailHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<MailHealthIndicator, JavaMailSenderImpl> {
        @Autowired(required=false)
        private Map<String, JavaMailSenderImpl> mailSenders;

        @Bean
        @ConditionalOnMissingBean(name={"mailHealthIndicator"})
        public HealthIndicator mailHealthIndicator() {
            return this.createHealthIndicator(this.mailSenders);
        }
    }

    @Configuration
    @ConditionalOnEnablednHealthIndicator(value="diskspace")
    public static class DiskSpaceHealthIndicatorConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"diskSpaceHealthIndicator"})
        public DiskSpaceHealthIndicator diskSpaceHealthIndicator(DiskSpaceHealthIndicatorProperties properties) {
            return new DiskSpaceHealthIndicator(properties);
        }

        @Bean
        public DiskSpaceHealthIndicatorProperties diskSpaceHealthIndicatorProperties() {
            return new DiskSpaceHealthIndicatorProperties();
        }
    }

    @Configuration
    @ConditionalOnBean(value={SolrServer.class})
    @ConditionalOnEnablednHealthIndicator(value="solr")
    public static class SolrHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<SolrHealthIndicator, SolrServer> {
        @Autowired
        private Map<String, SolrServer> solrServers;

        @Bean
        @ConditionalOnMissingBean(name={"solrHealthIndicator"})
        public HealthIndicator solrHealthIndicator() {
            return this.createHealthIndicator(this.solrServers);
        }
    }

    @Configuration
    @ConditionalOnBean(value={RabbitTemplate.class})
    @ConditionalOnEnablednHealthIndicator(value="rabbit")
    public static class RabbitHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<RabbitHealthIndicator, RabbitTemplate> {
        @Autowired
        private Map<String, RabbitTemplate> rabbitTemplates;

        @Bean
        @ConditionalOnMissingBean(name={"rabbitHealthIndicator"})
        public HealthIndicator rabbitHealthIndicator() {
            return this.createHealthIndicator(this.rabbitTemplates);
        }
    }

    @Configuration
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    @ConditionalOnEnablednHealthIndicator(value="redis")
    public static class RedisHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<RedisHealthIndicator, RedisConnectionFactory> {
        @Autowired
        private Map<String, RedisConnectionFactory> redisConnectionFactories;

        @Bean
        @ConditionalOnMissingBean(name={"redisHealthIndicator"})
        public HealthIndicator redisHealthIndicator() {
            return this.createHealthIndicator(this.redisConnectionFactories);
        }
    }

    @Configuration
    @ConditionalOnBean(value={MongoTemplate.class})
    @ConditionalOnEnablednHealthIndicator(value="mongo")
    public static class MongoHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<MongoHealthIndicator, MongoTemplate> {
        @Autowired
        private Map<String, MongoTemplate> mongoTemplates;

        @Bean
        @ConditionalOnMissingBean(name={"mongoHealthIndicator"})
        public HealthIndicator mongoHealthIndicator() {
            return this.createHealthIndicator(this.mongoTemplates);
        }
    }

    @Configuration
    @ConditionalOnClass(value={JdbcTemplate.class})
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnEnablednHealthIndicator(value="db")
    public static class DataSourcesHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<DataSourceHealthIndicator, DataSource>
    implements InitializingBean {
        @Autowired(required=false)
        private Map<String, DataSource> dataSources;
        @Autowired(required=false)
        private Collection<DataSourcePoolMetadataProvider> metadataProviders;
        private DataSourcePoolMetadataProvider poolMetadataProvider;

        public void afterPropertiesSet() throws Exception {
            this.poolMetadataProvider = new DataSourcePoolMetadataProviders(this.metadataProviders);
        }

        @Bean
        @ConditionalOnMissingBean(name={"dbHealthIndicator"})
        public HealthIndicator dbHealthIndicator() {
            return this.createHealthIndicator(this.dataSources);
        }

        @Override
        protected DataSourceHealthIndicator createHealthIndicator(DataSource source) {
            return new DataSourceHealthIndicator(source, this.getValidationQuery(source));
        }

        private String getValidationQuery(DataSource source) {
            DataSourcePoolMetadata poolMetadata = this.poolMetadataProvider.getDataSourcePoolMetadata(source);
            return poolMetadata == null ? null : poolMetadata.getValidationQuery();
        }
    }

    protected static abstract class CompositeHealthIndicatorConfiguration<H extends HealthIndicator, S> {
        @Autowired
        private HealthAggregator healthAggregator;

        protected CompositeHealthIndicatorConfiguration() {
        }

        protected HealthIndicator createHealthIndicator(Map<String, S> beans) {
            if (beans.size() == 1) {
                return this.createHealthIndicator(beans.values().iterator().next());
            }
            CompositeHealthIndicator composite = new CompositeHealthIndicator(this.healthAggregator);
            for (Map.Entry<String, S> entry : beans.entrySet()) {
                composite.addHealthIndicator(entry.getKey(), (HealthIndicator)this.createHealthIndicator(entry.getValue()));
            }
            return composite;
        }

        protected H createHealthIndicator(S source) {
            Class[] generics = ResolvableType.forClass(CompositeHealthIndicatorConfiguration.class, this.getClass()).resolveGenerics();
            Class indicatorClass = generics[0];
            Class sourceClass = generics[1];
            try {
                return (H)((HealthIndicator)indicatorClass.getConstructor(sourceClass).newInstance(source));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to create indicator " + indicatorClass + " for source " + sourceClass, ex);
            }
        }
    }
}

