/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cache;

import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.infinispan.spring.provider.SpringCache;
import org.springframework.boot.actuate.cache.AbstractJmxCacheStatisticsProvider;
import org.springframework.boot.actuate.cache.CacheStatistics;
import org.springframework.boot.actuate.cache.DefaultCacheStatistics;

public class InfinispanCacheStatisticsProvider
extends AbstractJmxCacheStatisticsProvider<SpringCache> {
    @Override
    protected ObjectName getObjectName(SpringCache cache) throws MalformedObjectNameException {
        ObjectName name = new ObjectName("org.infinispan:component=Statistics,type=Cache,name=\"" + cache.getName() + "(local)\",*");
        Set<ObjectInstance> instances = this.getMBeanServer().queryMBeans(name, null);
        if (instances.size() == 1) {
            return instances.iterator().next().getObjectName();
        }
        return null;
    }

    @Override
    protected CacheStatistics getCacheStatistics(ObjectName objectName) {
        DefaultCacheStatistics statistics = new DefaultCacheStatistics();
        Integer size = this.getAttribute(objectName, "numberOfEntries", Integer.class);
        if (size != null) {
            statistics.setSize((long)size);
            if (size > 0) {
                this.initalizeStats(objectName, statistics);
            }
        }
        return statistics;
    }

    private void initalizeStats(ObjectName objectName, DefaultCacheStatistics statistics) {
        Double hitRatio = this.getAttribute(objectName, "hitRatio", Double.class);
        if (hitRatio != null) {
            statistics.setHitRatio(hitRatio);
            statistics.setMissRatio(1.0 - hitRatio);
        }
    }
}

