/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementContextResolver;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.AuthenticationManagerConfiguration;
import org.springframework.boot.autoconfigure.security.FallbackWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityPrerequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.SpringBootWebSecurityConfiguration;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfiguration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={EnableWebSecurity.class})
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
@AutoConfigureBefore(value={FallbackWebSecurityAutoConfiguration.class})
@EnableConfigurationProperties
public class ManagementWebSecurityAutoConfiguration {
    private static final String[] NO_PATHS = new String[0];

    @Bean
    @ConditionalOnMissingBean(value={IgnoredPathsWebSecurityConfigurerAdapter.class})
    public IgnoredPathsWebSecurityConfigurerAdapter ignoredPathsWebSecurityConfigurerAdapter() {
        return new IgnoredPathsWebSecurityConfigurerAdapter();
    }

    private static String[] getEndpointPaths(EndpointHandlerMapping endpointHandlerMapping) {
        return StringUtils.mergeStringArrays((String[])ManagementWebSecurityAutoConfiguration.getEndpointPaths(endpointHandlerMapping, false), (String[])ManagementWebSecurityAutoConfiguration.getEndpointPaths(endpointHandlerMapping, true));
    }

    private static String[] getEndpointPaths(EndpointHandlerMapping endpointHandlerMapping, boolean secure) {
        if (endpointHandlerMapping == null) {
            return NO_PATHS;
        }
        Set<? extends MvcEndpoint> endpoints = endpointHandlerMapping.getEndpoints();
        LinkedHashSet<String> paths = new LinkedHashSet<String>(endpoints.size());
        for (MvcEndpoint mvcEndpoint : endpoints) {
            if (mvcEndpoint.isSensitive() != secure) continue;
            String path = endpointHandlerMapping.getPath(mvcEndpoint.getPath());
            paths.add(path);
            if (!path.equals("")) {
                paths.add(path + "/**");
                paths.add(path + ".*");
                continue;
            }
            paths.add("/");
        }
        return paths.toArray(new String[paths.size()]);
    }

    @Configuration
    @ConditionalOnMissingBean(value={ManagementWebSecurityConfigurerAdapter.class})
    @ConditionalOnProperty(prefix="management.security", name={"enabled"}, matchIfMissing=true)
    @Order(value=0x7FFFFFF5)
    protected static class ManagementWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private SecurityProperties security;
        @Autowired
        private ManagementServerProperties management;
        @Autowired(required=false)
        private ManagementContextResolver contextResolver;
        @Autowired(required=false)
        private ServerProperties server;
        @Autowired(required=false)
        private EndpointHandlerMapping endpointHandlerMapping;

        protected ManagementWebSecurityConfigurerAdapter() {
        }

        public void setEndpointHandlerMapping(EndpointHandlerMapping endpointHandlerMapping) {
            this.endpointHandlerMapping = endpointHandlerMapping;
        }

        protected final void deduceEndpointHandlerMappingIfMissing() {
            if (this.endpointHandlerMapping == null) {
                ApplicationContext context;
                ApplicationContext applicationContext = context = this.contextResolver == null ? null : this.contextResolver.getApplicationContext();
                if (context != null && context.getBeanNamesForType(EndpointHandlerMapping.class).length > 0) {
                    this.endpointHandlerMapping = (EndpointHandlerMapping)((Object)context.getBean(EndpointHandlerMapping.class));
                }
                if (this.endpointHandlerMapping == null) {
                    this.endpointHandlerMapping = new EndpointHandlerMapping(Collections.emptySet());
                }
            }
        }

        protected void configure(HttpSecurity http) throws Exception {
            RequestMatcher matcher = this.getRequestMatcher();
            if (matcher != null) {
                if (this.security.isRequireSsl()) {
                    ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
                }
                AuthenticationEntryPoint entryPoint = this.entryPoint();
                http.exceptionHandling().authenticationEntryPoint(entryPoint);
                http.requestMatcher(matcher);
                this.configureAuthorizeRequests(new EndpointPathRequestMatcher(false), http.authorizeRequests());
                http.httpBasic().authenticationEntryPoint(entryPoint);
                http.csrf().disable();
                http.sessionManagement().sessionCreationPolicy(this.management.getSecurity().getSessions());
                SpringBootWebSecurityConfiguration.configureHeaders((HeadersConfigurer)http.headers(), (SecurityProperties.Headers)this.security.getHeaders());
            }
        }

        private RequestMatcher getRequestMatcher() {
            if (!this.management.getSecurity().isEnabled()) {
                return null;
            }
            String path = this.management.getContextPath();
            if (StringUtils.hasText((String)path)) {
                AntPathRequestMatcher matcher = new AntPathRequestMatcher(this.server.getPath(path) + "/**");
                return matcher;
            }
            return new EndpointPathRequestMatcher();
        }

        private AuthenticationEntryPoint entryPoint() {
            BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
            entryPoint.setRealmName(this.security.getBasic().getRealm());
            return entryPoint;
        }

        private void configureAuthorizeRequests(RequestMatcher permitAllMatcher, ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{permitAllMatcher})).permitAll();
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).hasRole(this.management.getSecurity().getRole());
        }

        private final class EndpointPathRequestMatcher
        implements RequestMatcher {
            private boolean sensitive;
            private RequestMatcher delegate;

            public EndpointPathRequestMatcher(boolean sensitive) {
                this.sensitive = sensitive;
            }

            public EndpointPathRequestMatcher() {
                this(true);
            }

            public boolean matches(HttpServletRequest request) {
                ManagementWebSecurityConfigurerAdapter.this.deduceEndpointHandlerMappingIfMissing();
                if (this.delegate == null) {
                    this.delegate = this.createDelegate();
                }
                return this.delegate.matches(request);
            }

            private RequestMatcher createDelegate() {
                ServerProperties server = ManagementWebSecurityConfigurerAdapter.this.server;
                ArrayList<AntPathRequestMatcher> matchers = new ArrayList<AntPathRequestMatcher>();
                for (String path : this.getPaths()) {
                    matchers.add(new AntPathRequestMatcher(server.getPath(path)));
                }
                return matchers.isEmpty() ? AnyRequestMatcher.INSTANCE : new OrRequestMatcher(matchers);
            }

            private String[] getPaths() {
                EndpointHandlerMapping endpointHandlerMapping = ManagementWebSecurityConfigurerAdapter.this.endpointHandlerMapping;
                if (this.sensitive) {
                    return ManagementWebSecurityAutoConfiguration.getEndpointPaths(endpointHandlerMapping);
                }
                return ManagementWebSecurityAutoConfiguration.getEndpointPaths(endpointHandlerMapping, false);
            }
        }
    }

    static class WebSecurityEnablerCondition
    extends SpringBootCondition {
        WebSecurityEnablerCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String managementEnabled = context.getEnvironment().getProperty("management.security.enabled", "true");
            String basicEnabled = context.getEnvironment().getProperty("security.basic.enabled", "true");
            return new ConditionOutcome("true".equalsIgnoreCase(managementEnabled) && !"true".equalsIgnoreCase(basicEnabled), "Management security enabled and basic disabled");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={WebSecurityConfiguration.class})
    @Conditional(value={WebSecurityEnablerCondition.class})
    @EnableWebSecurity
    protected static class WebSecurityEnabler
    extends AuthenticationManagerConfiguration {
        protected WebSecurityEnabler() {
        }
    }

    @Order(value=-2147483647)
    private static class IgnoredPathsWebSecurityConfigurerAdapter
    implements WebSecurityConfigurer<WebSecurity> {
        @Autowired(required=false)
        private ErrorController errorController;
        @Autowired(required=false)
        private EndpointHandlerMapping endpointHandlerMapping;
        @Autowired
        private ManagementServerProperties management;
        @Autowired
        private SecurityProperties security;
        @Autowired(required=false)
        private ServerProperties server;

        private IgnoredPathsWebSecurityConfigurerAdapter() {
        }

        public void configure(WebSecurity builder) throws Exception {
        }

        public void init(WebSecurity builder) throws Exception {
            WebSecurity.IgnoredRequestConfigurer ignoring = builder.ignoring();
            List ignored = SpringBootWebSecurityConfiguration.getIgnored((SecurityProperties)this.security);
            if (!this.management.getSecurity().isEnabled()) {
                ignored.addAll(Arrays.asList(ManagementWebSecurityAutoConfiguration.getEndpointPaths(this.endpointHandlerMapping)));
            }
            if (ignored.contains("none")) {
                ignored.remove("none");
            }
            if (this.errorController != null) {
                ignored.add(this.normalizePath(this.errorController.getErrorPath()));
            }
            if (this.server != null) {
                String[] paths = this.server.getPathsArray((Collection)ignored);
                ignoring.antMatchers(paths);
            }
        }

        private String normalizePath(String errorPath) {
            String result = StringUtils.cleanPath((String)errorPath);
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
            return result;
        }
    }

    @Configuration
    protected static class ManagementSecurityPropertiesConfiguration
    implements SecurityPrerequisite {
        @Autowired(required=false)
        private SecurityProperties security;
        @Autowired(required=false)
        private ManagementServerProperties management;

        protected ManagementSecurityPropertiesConfiguration() {
        }

        @PostConstruct
        public void init() {
            if (this.management != null && this.security != null) {
                this.security.getUser().getRole().add(this.management.getSecurity().getRole());
            }
        }
    }
}

