/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnEnabledHealthIndicatorCondition
extends SpringBootCondition {
    private static final String ANNOTATION_CLASS = ConditionalOnEnabledHealthIndicator.class.getName();

    OnEnabledHealthIndicatorCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ANNOTATION_CLASS));
        String endpointName = annotationAttributes.getString("value");
        ConditionOutcome outcome = this.getHealthIndicatorOutcome(context, endpointName);
        if (outcome != null) {
            return outcome;
        }
        return this.getDefaultIndicatorsOutcome(context);
    }

    private ConditionOutcome getHealthIndicatorOutcome(ConditionContext context, String endpointName) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "management.health." + endpointName + ".");
        if (resolver.containsProperty("enabled")) {
            boolean match = (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)true);
            return new ConditionOutcome(match, "The health indicator " + endpointName + " is " + (match ? "enabled" : "disabled"));
        }
        return null;
    }

    private ConditionOutcome getDefaultIndicatorsOutcome(ConditionContext context) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "management.health.defaults.");
        boolean match = Boolean.valueOf(resolver.getProperty("enabled", "true"));
        return new ConditionOutcome(match, "All default health indicators are " + (match ? "enabled" : "disabled") + " by default");
    }
}

