/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.TraceRepositoryAutoConfiguration;
import org.springframework.boot.actuate.trace.TraceProperties;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.actuate.trace.WebRequestTraceFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.DispatcherServlet;

@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, ServletRegistration.class})
@AutoConfigureAfter(value={TraceRepositoryAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceProperties.class})
public class TraceWebFilterAutoConfiguration {
    @Autowired
    private TraceRepository traceRepository;
    @Autowired(required=false)
    private ErrorAttributes errorAttributes;
    @Value(value="${management.dump_requests:false}")
    private boolean dumpRequests;
    @Autowired
    TraceProperties traceProperties = new TraceProperties();

    @Bean
    public WebRequestTraceFilter webRequestLoggingFilter(BeanFactory beanFactory) {
        WebRequestTraceFilter filter = new WebRequestTraceFilter(this.traceRepository, this.traceProperties);
        filter.setDumpRequests(this.dumpRequests);
        if (this.errorAttributes != null) {
            filter.setErrorAttributes(this.errorAttributes);
        }
        return filter;
    }
}

