/*
 * Copyright 2012-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.actuate.autoconfigure;

import org.springframework.context.annotation.Condition;

/**
 * {@link Condition} that checks if a health indicator is enabled.
 *
 * @author Stephane Nicoll
 */
class OnEnabledHealthIndicatorCondition extends OnEnabledEndpointElementCondition {

	OnEnabledHealthIndicatorCondition() {
		super("management.health.", ConditionalOnEnabledHealthIndicator.class);
	}

	@Override
	protected String getEndpointElementOutcomeMessage(String name, boolean match) {
		return "The health indicator " + name + " is " + (match ? "enabled" : "disabled");
	}

	@Override
	protected String getDefaultEndpointElementOutcomeMessage(boolean match) {
		return "All default health indicators are " + (match ? "enabled" : "disabled")
				+ " by default";
	}

}
