/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@ManagedResource
public class EndpointMBean {
    private final Endpoint<?> endpoint;
    private final ObjectMapper mapper;
    private final JavaType listObject;
    private final JavaType mapStringObject;

    public EndpointMBean(String beanName, Endpoint<?> endpoint, ObjectMapper objectMapper) {
        Assert.notNull((Object)beanName, (String)"BeanName must not be null");
        Assert.notNull(endpoint, (String)"Endpoint must not be null");
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.endpoint = endpoint;
        this.mapper = objectMapper;
        this.listObject = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{Object.class});
        this.mapStringObject = objectMapper.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, Object.class});
    }

    @ManagedAttribute(description="Returns the class of the underlying endpoint")
    public String getEndpointClass() {
        return ClassUtils.getQualifiedName(this.endpoint.getClass());
    }

    @ManagedAttribute(description="Indicates whether the underlying endpoint exposes sensitive information")
    public boolean isSensitive() {
        return this.endpoint.isSensitive();
    }

    public Endpoint<?> getEndpoint() {
        return this.endpoint;
    }

    protected Object convert(Object result) {
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return result;
        }
        if (result.getClass().isArray() || result instanceof List) {
            return this.mapper.convertValue(result, this.listObject);
        }
        return this.mapper.convertValue(result, this.mapStringObject);
    }
}

