/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cache;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import org.springframework.boot.actuate.cache.CacheStatistics;
import org.springframework.boot.actuate.cache.CacheStatisticsProvider;
import org.springframework.boot.actuate.cache.DefaultCacheStatistics;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;

public class CaffeineCacheStatisticsProvider
implements CacheStatisticsProvider<CaffeineCache> {
    @Override
    public CacheStatistics getCacheStatistics(CacheManager cacheManager, CaffeineCache cache) {
        DefaultCacheStatistics statistics = new DefaultCacheStatistics();
        statistics.setSize(cache.getNativeCache().estimatedSize());
        CacheStats caffeineStatistics = cache.getNativeCache().stats();
        if (caffeineStatistics.requestCount() > 0L) {
            statistics.setHitRatio(caffeineStatistics.hitRate());
            statistics.setMissRatio(caffeineStatistics.missRate());
        }
        return statistics;
    }
}

