/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import liquibase.integration.spring.SpringLiquibase;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.AutoConfigurationReportEndpoint;
import org.springframework.boot.actuate.endpoint.BeansEndpoint;
import org.springframework.boot.actuate.endpoint.ConfigurationPropertiesReportEndpoint;
import org.springframework.boot.actuate.endpoint.DumpEndpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.FlywayEndpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.InfoEndpoint;
import org.springframework.boot.actuate.endpoint.LiquibaseEndpoint;
import org.springframework.boot.actuate.endpoint.LoggersEndpoint;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.endpoint.RequestMappingEndpoint;
import org.springframework.boot.actuate.endpoint.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.TraceEndpoint;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.trace.InMemoryTraceRepository;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;

@Configuration
@AutoConfigureAfter(value={FlywayAutoConfiguration.class, LiquibaseAutoConfiguration.class})
@EnableConfigurationProperties(value={EndpointProperties.class})
public class EndpointAutoConfiguration {
    private final HealthAggregator healthAggregator;
    private final Map<String, HealthIndicator> healthIndicators;
    private final List<InfoContributor> infoContributors;
    private final Collection<PublicMetrics> publicMetrics;
    private final TraceRepository traceRepository;

    public EndpointAutoConfiguration(ObjectProvider<HealthAggregator> healthAggregator, ObjectProvider<Map<String, HealthIndicator>> healthIndicators, ObjectProvider<List<InfoContributor>> infoContributors, ObjectProvider<Collection<PublicMetrics>> publicMetrics, ObjectProvider<TraceRepository> traceRepository) {
        this.healthAggregator = (HealthAggregator)healthAggregator.getIfAvailable();
        this.healthIndicators = (Map)healthIndicators.getIfAvailable();
        this.infoContributors = (List)infoContributors.getIfAvailable();
        this.publicMetrics = (Collection)publicMetrics.getIfAvailable();
        this.traceRepository = (TraceRepository)traceRepository.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public EnvironmentEndpoint environmentEndpoint() {
        return new EnvironmentEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthEndpoint healthEndpoint() {
        return new HealthEndpoint(this.healthAggregator == null ? new OrderedHealthAggregator() : this.healthAggregator, this.healthIndicators == null ? Collections.emptyMap() : this.healthIndicators);
    }

    @Bean
    @ConditionalOnMissingBean
    public BeansEndpoint beansEndpoint() {
        return new BeansEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public InfoEndpoint infoEndpoint() throws Exception {
        return new InfoEndpoint(this.infoContributors == null ? Collections.emptyList() : this.infoContributors);
    }

    @Bean
    @ConditionalOnBean(value={LoggingSystem.class})
    @ConditionalOnMissingBean
    public LoggersEndpoint loggersEndpoint(LoggingSystem loggingSystem) {
        return new LoggersEndpoint(loggingSystem);
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricsEndpoint metricsEndpoint() {
        ArrayList<PublicMetrics> publicMetrics = new ArrayList<PublicMetrics>();
        if (this.publicMetrics != null) {
            publicMetrics.addAll(this.publicMetrics);
        }
        Collections.sort(publicMetrics, AnnotationAwareOrderComparator.INSTANCE);
        return new MetricsEndpoint(publicMetrics);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceEndpoint traceEndpoint() {
        return new TraceEndpoint(this.traceRepository == null ? new InMemoryTraceRepository() : this.traceRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    public DumpEndpoint dumpEndpoint() {
        return new DumpEndpoint();
    }

    @Bean
    @ConditionalOnBean(value={ConditionEvaluationReport.class})
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public AutoConfigurationReportEndpoint autoConfigurationReportEndpoint() {
        return new AutoConfigurationReportEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public ShutdownEndpoint shutdownEndpoint() {
        return new ShutdownEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationPropertiesReportEndpoint configurationPropertiesReportEndpoint() {
        return new ConfigurationPropertiesReportEndpoint();
    }

    @Configuration
    @ConditionalOnClass(value={AbstractHandlerMethodMapping.class})
    protected static class RequestMappingEndpointConfiguration {
        protected RequestMappingEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RequestMappingEndpoint requestMappingEndpoint() {
            RequestMappingEndpoint endpoint = new RequestMappingEndpoint();
            return endpoint;
        }
    }

    @Configuration
    @ConditionalOnBean(value={SpringLiquibase.class})
    @ConditionalOnClass(value={SpringLiquibase.class})
    static class LiquibaseEndpointConfiguration {
        LiquibaseEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public LiquibaseEndpoint liquibaseEndpoint(Map<String, SpringLiquibase> liquibases) {
            return new LiquibaseEndpoint(liquibases);
        }
    }

    @Configuration
    @ConditionalOnBean(value={Flyway.class})
    @ConditionalOnClass(value={Flyway.class})
    static class FlywayEndpointConfiguration {
        FlywayEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public FlywayEndpoint flywayEndpoint(Map<String, Flyway> flyways) {
            return new FlywayEndpoint(flyways);
        }
    }
}

