/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.InMemoryMetricRepository;
import org.springframework.boot.actuate.metrics.repository.MultiMetricRepository;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.util.Assert;

public class InMemoryMultiMetricRepository
implements MultiMetricRepository {
    private final InMemoryMetricRepository repository;
    private final Collection<String> groups = new HashSet<String>();

    public InMemoryMultiMetricRepository() {
        this(new InMemoryMetricRepository());
    }

    public InMemoryMultiMetricRepository(InMemoryMetricRepository repository) {
        Assert.notNull((Object)repository, (String)"Repository must not be null");
        this.repository = repository;
    }

    @Override
    public void set(String group, Collection<Metric<?>> values) {
        String prefix = group;
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        for (Metric<?> metric : values) {
            if (!metric.getName().startsWith(prefix)) {
                metric = new Metric(prefix + metric.getName(), metric.getValue(), metric.getTimestamp());
            }
            this.repository.set(metric);
        }
        this.groups.add(group);
    }

    @Override
    public void increment(String group, Delta<?> delta) {
        String prefix = group;
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if (!delta.getName().startsWith(prefix)) {
            delta = new Delta(prefix + delta.getName(), delta.getValue(), delta.getTimestamp());
        }
        this.repository.increment(delta);
        this.groups.add(group);
    }

    @Override
    public Iterable<String> groups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    @Override
    public long countGroups() {
        return this.groups.size();
    }

    @Override
    public void reset(String group) {
        for (Metric<?> metric : this.findAll(group)) {
            this.repository.reset(metric.getName());
        }
        this.groups.remove(group);
    }

    @Override
    public Iterable<Metric<?>> findAll(String metricNamePrefix) {
        return this.repository.findAllWithPrefix(metricNamePrefix);
    }
}

