/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.Properties;
import org.jolokia.http.AgentServlet;
import org.springframework.boot.actuate.autoconfigure.JolokiaProperties;
import org.springframework.boot.actuate.autoconfigure.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.actuate.endpoint.mvc.JolokiaMvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.web.servlet.mvc.ServletWrappingController;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={AgentServlet.class, ServletWrappingController.class})
@Conditional(value={JolokiaCondition.class})
@AutoConfigureBefore(value={ManagementWebSecurityAutoConfiguration.class})
@AutoConfigureAfter(value={ServletWebServerFactoryAutoConfiguration.class})
@EnableConfigurationProperties(value={JolokiaProperties.class})
public class JolokiaAutoConfiguration {
    private final JolokiaProperties properties;

    public JolokiaAutoConfiguration(JolokiaProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public JolokiaMvcEndpoint jolokiaEndpoint() {
        JolokiaMvcEndpoint endpoint = new JolokiaMvcEndpoint();
        endpoint.setInitParameters(this.getInitParameters());
        return endpoint;
    }

    private Properties getInitParameters() {
        Properties initParameters = new Properties();
        initParameters.putAll(this.properties.getConfig());
        return initParameters;
    }

    static class JolokiaCondition
    extends SpringBootCondition {
        JolokiaCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean endpointsEnabled = this.isEnabled(context, "endpoints.", true);
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Jolokia", (Object[])new Object[0]);
            if (this.isEnabled(context, "endpoints.jolokia.", endpointsEnabled)) {
                return ConditionOutcome.match((ConditionMessage)message.because("enabled"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
        }

        private boolean isEnabled(ConditionContext context, String prefix, boolean defaultValue) {
            return (Boolean)context.getEnvironment().getProperty(prefix + "enabled", Boolean.class, (Object)defaultValue);
        }
    }
}

