/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

abstract class NamePatternFilter<T> {
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+", "["};
    private final T source;

    NamePatternFilter(T source) {
        this.source = source;
    }

    public Map<String, Object> getResults(String name) {
        if (!this.isRegex(name)) {
            Object value = this.getValue(this.source, name);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(name, value);
            return result;
        }
        Pattern pattern = Pattern.compile(name);
        ResultCollectingNameCallback resultCollector = new ResultCollectingNameCallback(pattern);
        this.getNames(this.source, resultCollector);
        return resultCollector.getResults();
    }

    private boolean isRegex(String name) {
        for (String part : REGEX_PARTS) {
            if (!name.contains(part)) continue;
            return true;
        }
        return false;
    }

    protected abstract void getNames(T var1, NameCallback var2);

    protected abstract Object getValue(T var1, String var2);

    protected abstract Object getOptionalValue(T var1, String var2);

    private class ResultCollectingNameCallback
    implements NameCallback {
        private final Pattern pattern;
        private final Map<String, Object> results = new LinkedHashMap<String, Object>();

        ResultCollectingNameCallback(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public void addName(String name) {
            Object value;
            if (this.pattern.matcher(name).matches() && (value = NamePatternFilter.this.getOptionalValue(NamePatternFilter.this.source, name)) != null) {
                this.results.put(name, value);
            }
        }

        public Map<String, Object> getResults() {
            return this.results;
        }
    }

    static interface NameCallback {
        public void addName(String var1);
    }
}

