/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.statsd;

import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import java.io.Closeable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StatsdMetricWriter
implements MetricWriter,
Closeable {
    private static final Log logger = LogFactory.getLog(StatsdMetricWriter.class);
    private final StatsDClient client;

    public StatsdMetricWriter(String host, int port) {
        this(null, host, port);
    }

    public StatsdMetricWriter(String prefix, String host, int port) {
        this((StatsDClient)new NonBlockingStatsDClient(StatsdMetricWriter.trimPrefix(prefix), host, port, (StatsDClientErrorHandler)new LoggingStatsdErrorHandler()));
    }

    public StatsdMetricWriter(StatsDClient client) {
        Assert.notNull((Object)client, (String)"Client must not be null");
        this.client = client;
    }

    private static String trimPrefix(String prefix) {
        String trimmedPrefix;
        String string = trimmedPrefix = StringUtils.hasText((String)prefix) ? prefix : null;
        while (trimmedPrefix != null && trimmedPrefix.endsWith(".")) {
            trimmedPrefix = trimmedPrefix.substring(0, trimmedPrefix.length() - 1);
        }
        return trimmedPrefix;
    }

    @Override
    public void increment(Delta<?> delta) {
        this.client.count(this.sanitizeMetricName(delta.getName()), ((Number)delta.getValue()).longValue());
    }

    @Override
    public void set(Metric<?> value) {
        String name = this.sanitizeMetricName(value.getName());
        if (name.contains("timer.") && !name.contains("gauge.") && !name.contains("counter.")) {
            this.client.recordExecutionTime(name, ((Number)value.getValue()).longValue());
        } else if (name.contains("counter.")) {
            this.client.count(name, ((Number)value.getValue()).longValue());
        } else {
            this.client.gauge(name, ((Number)value.getValue()).doubleValue());
        }
    }

    @Override
    public void reset(String name) {
    }

    @Override
    public void close() {
        this.client.stop();
    }

    private String sanitizeMetricName(String name) {
        return name.replace(":", "-");
    }

    private static final class LoggingStatsdErrorHandler
    implements StatsDClientErrorHandler {
        private LoggingStatsdErrorHandler() {
        }

        public void handle(Exception e) {
            logger.debug((Object)("Failed to write metric. Exception: " + e.getClass() + ", message: " + e.getMessage()));
        }
    }
}

