/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebOperation;

public class EndpointLinksResolver {
    public Map<String, Link> resolveLinks(Collection<ExposableWebEndpoint> endpoints, String requestUrl) {
        String normalizedUrl = this.normalizeRequestUrl(requestUrl);
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        links.put("self", new Link(normalizedUrl));
        for (ExposableWebEndpoint endpoint : endpoints) {
            for (WebOperation operation : endpoint.getOperations()) {
                endpoints.stream().map(ExposableEndpoint::getId).forEach(id -> links.put(operation.getId(), this.createLink(normalizedUrl, operation)));
            }
        }
        return links;
    }

    private String normalizeRequestUrl(String requestUrl) {
        if (requestUrl.endsWith("/")) {
            return requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }

    private Link createLink(String requestUrl, WebOperation operation) {
        String path = operation.getRequestPredicate().getPath();
        return new Link(requestUrl + (path.startsWith("/") ? path : "/" + path));
    }
}

