/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveHealthIndicator
implements ReactiveHealthIndicator {
    @Override
    public final Mono<Health> health() {
        try {
            return this.doHealthCheck(new Health.Builder()).onErrorResume(this::handleFailure);
        }
        catch (Exception ex) {
            return this.handleFailure(ex);
        }
    }

    private Mono<Health> handleFailure(Throwable ex) {
        return Mono.just((Object)new Health.Builder().down(ex).build());
    }

    protected abstract Mono<Health> doHealthCheck(Health.Builder var1);
}

