/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.redis;

import java.util.Properties;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import reactor.core.publisher.Mono;

public class RedisReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveRedisConnectionFactory connectionFactory;

    public RedisReactiveHealthIndicator(ReactiveRedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        ReactiveRedisConnection connection = this.connectionFactory.getReactiveConnection();
        return connection.serverCommands().info().map(info -> this.up(builder, (Properties)info)).doFinally(signal -> connection.close());
    }

    private Health up(Health.Builder builder, Properties info) {
        return builder.up().withDetail("version", info.getProperty("redis_version")).build();
    }
}

