/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.client;

import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.regex.Pattern;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;

public final class RestTemplateExchangeTags {
    private static final Pattern STRIP_URI_PATTERN = Pattern.compile("^https?://[^/]+/");
    private static final Tag OUTCOME_UNKNOWN = Tag.of((String)"outcome", (String)"UNKNOWN");
    private static final Tag OUTCOME_INFORMATIONAL = Tag.of((String)"outcome", (String)"INFORMATIONAL");
    private static final Tag OUTCOME_SUCCESS = Tag.of((String)"outcome", (String)"SUCCESS");
    private static final Tag OUTCOME_REDIRECTION = Tag.of((String)"outcome", (String)"REDIRECTION");
    private static final Tag OUTCOME_CLIENT_ERROR = Tag.of((String)"outcome", (String)"CLIENT_ERROR");
    private static final Tag OUTCOME_SERVER_ERROR = Tag.of((String)"outcome", (String)"SERVER_ERROR");

    private RestTemplateExchangeTags() {
    }

    public static Tag method(HttpRequest request) {
        return Tag.of((String)"method", (String)request.getMethod().name());
    }

    public static Tag uri(HttpRequest request) {
        return Tag.of((String)"uri", (String)RestTemplateExchangeTags.ensureLeadingSlash(RestTemplateExchangeTags.stripUri(request.getURI().toString())));
    }

    public static Tag uri(String uriTemplate) {
        String uri = StringUtils.hasText((String)uriTemplate) ? uriTemplate : "none";
        return Tag.of((String)"uri", (String)RestTemplateExchangeTags.ensureLeadingSlash(RestTemplateExchangeTags.stripUri(uri)));
    }

    private static String stripUri(String uri) {
        return STRIP_URI_PATTERN.matcher(uri).replaceAll("");
    }

    private static String ensureLeadingSlash(String url) {
        return url == null || url.startsWith("/") ? url : "/" + url;
    }

    public static Tag status(ClientHttpResponse response) {
        return Tag.of((String)"status", (String)RestTemplateExchangeTags.getStatusMessage(response));
    }

    private static String getStatusMessage(ClientHttpResponse response) {
        try {
            if (response == null) {
                return "CLIENT_ERROR";
            }
            return String.valueOf(response.getRawStatusCode());
        }
        catch (IOException ex) {
            return "IO_ERROR";
        }
    }

    public static Tag clientName(HttpRequest request) {
        String host = request.getURI().getHost();
        if (host == null) {
            host = "none";
        }
        return Tag.of((String)"clientName", (String)host);
    }

    public static Tag outcome(ClientHttpResponse response) {
        try {
            if (response != null) {
                HttpStatus statusCode = response.getStatusCode();
                if (statusCode.is1xxInformational()) {
                    return OUTCOME_INFORMATIONAL;
                }
                if (statusCode.is2xxSuccessful()) {
                    return OUTCOME_SUCCESS;
                }
                if (statusCode.is3xxRedirection()) {
                    return OUTCOME_REDIRECTION;
                }
                if (statusCode.is4xxClientError()) {
                    return OUTCOME_CLIENT_ERROR;
                }
                if (statusCode.is5xxServerError()) {
                    return OUTCOME_SERVER_ERROR;
                }
            }
            return OUTCOME_UNKNOWN;
        }
        catch (IOException | IllegalArgumentException ex) {
            return OUTCOME_UNKNOWN;
        }
    }
}

