/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.elasticsearch;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.cluster.Health;
import java.util.Map;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;

public class ElasticsearchJestHealthIndicator
extends AbstractHealthIndicator {
    private final JestClient jestClient;
    private final JsonParser jsonParser = JsonParserFactory.getJsonParser();

    public ElasticsearchJestHealthIndicator(JestClient jestClient) {
        super("Elasticsearch health check failed");
        this.jestClient = jestClient;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        JestResult healthResult = this.jestClient.execute((Action)new Health.Builder().build());
        if (healthResult.getResponseCode() != 200 || !healthResult.isSucceeded()) {
            builder.down();
            builder.withDetail("statusCode", healthResult.getResponseCode());
        } else {
            Map response = this.jsonParser.parseMap(healthResult.getJsonString());
            String status = (String)response.get("status");
            if (status.equals(Health.Status.RED.getKey())) {
                builder.outOfService();
            } else {
                builder.up();
            }
            builder.withDetails(response);
        }
    }
}

