/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.ssl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.Status;
import org.springframework.boot.info.SslInfo;
import org.springframework.util.Assert;

public class SslHealthIndicator
extends AbstractHealthIndicator {
    private final SslInfo sslInfo;
    private final Duration expiryThreshold;

    public SslHealthIndicator(SslInfo sslInfo, Duration expiryThreshold) {
        super("SSL health check failed");
        Assert.notNull((Object)sslInfo, (String)"'sslInfo' must not be null");
        this.sslInfo = sslInfo;
        this.expiryThreshold = expiryThreshold;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        ArrayList<SslInfo.CertificateChainInfo> validCertificateChains = new ArrayList<SslInfo.CertificateChainInfo>();
        ArrayList<SslInfo.CertificateChainInfo> invalidCertificateChains = new ArrayList<SslInfo.CertificateChainInfo>();
        ArrayList<SslInfo.CertificateChainInfo> expiringCerificateChains = new ArrayList<SslInfo.CertificateChainInfo>();
        for (SslInfo.BundleInfo bundle : this.sslInfo.getBundles()) {
            for (SslInfo.CertificateChainInfo certificateChain : bundle.getCertificateChains()) {
                if (this.containsOnlyValidCertificates(certificateChain)) {
                    validCertificateChains.add(certificateChain);
                    if (!this.containsExpiringCertificate(certificateChain)) continue;
                    expiringCerificateChains.add(certificateChain);
                    continue;
                }
                if (!this.containsInvalidCertificate(certificateChain)) continue;
                invalidCertificateChains.add(certificateChain);
            }
        }
        builder.status(invalidCertificateChains.isEmpty() ? Status.UP : Status.OUT_OF_SERVICE);
        builder.withDetail("expiringChains", expiringCerificateChains);
        builder.withDetail("invalidChains", invalidCertificateChains);
        builder.withDetail("validChains", validCertificateChains);
    }

    private boolean containsOnlyValidCertificates(SslInfo.CertificateChainInfo certificateChain) {
        return this.validatableCertificates(certificateChain).allMatch(this::isValidCertificate);
    }

    private boolean containsInvalidCertificate(SslInfo.CertificateChainInfo certificateChain) {
        return this.validatableCertificates(certificateChain).anyMatch(this::isNotValidCertificate);
    }

    private boolean containsExpiringCertificate(SslInfo.CertificateChainInfo certificateChain) {
        return this.validatableCertificates(certificateChain).anyMatch(this::isExpiringCertificate);
    }

    private Stream<SslInfo.CertificateInfo> validatableCertificates(SslInfo.CertificateChainInfo certificateChain) {
        return certificateChain.getCertificates().stream().filter(certificate -> certificate.getValidity() != null);
    }

    private boolean isValidCertificate(SslInfo.CertificateInfo certificate) {
        return certificate.getValidity().getStatus().isValid();
    }

    private boolean isNotValidCertificate(SslInfo.CertificateInfo certificate) {
        return !this.isValidCertificate(certificate);
    }

    private boolean isExpiringCertificate(SslInfo.CertificateInfo certificate) {
        return Instant.now().plus(this.expiryThreshold).isAfter(certificate.getValidityEnds());
    }
}

