/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.docker.compose;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.amqp.autoconfigure.RabbitConnectionDetails;
import org.springframework.boot.amqp.docker.compose.RabbitEnvironment;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class RabbitDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<RabbitConnectionDetails> {
    private static final String[] RABBITMQ_CONTAINER_NAMES = new String[]{"rabbitmq", "bitnami/rabbitmq"};
    private static final int RABBITMQ_PORT = 5672;

    protected RabbitDockerComposeConnectionDetailsFactory() {
        super(RABBITMQ_CONTAINER_NAMES, new String[0]);
    }

    protected RabbitConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new RabbitDockerComposeConnectionDetails(source.getRunningService());
    }

    static class RabbitDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements RabbitConnectionDetails {
        private final RabbitEnvironment environment;
        private final List<RabbitConnectionDetails.Address> addresses;

        protected RabbitDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new RabbitEnvironment(service.env());
            this.addresses = List.of(new RabbitConnectionDetails.Address(service.host(), service.ports().get(5672)));
        }

        @Override
        public @Nullable String getUsername() {
            return this.environment.getUsername();
        }

        @Override
        public @Nullable String getPassword() {
            return this.environment.getPassword();
        }

        @Override
        public String getVirtualHost() {
            return "/";
        }

        @Override
        public List<RabbitConnectionDetails.Address> getAddresses() {
            return this.addresses;
        }
    }
}

