/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

public abstract class JpaBaseConfiguration
implements BeanFactoryAware,
EnvironmentAware {
    private ConfigurableListableBeanFactory beanFactory;
    private RelaxedPropertyResolver environment;

    public void setEnvironment(Environment environment) {
        this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.jpa.");
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        return new JpaTransactionManager(this.entityManagerFactory().getObject());
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setJpaVendorAdapter(this.jpaVendorAdapter());
        entityManagerFactoryBean.setDataSource(this.getDataSource());
        entityManagerFactoryBean.setPackagesToScan(this.getPackagesToScan());
        entityManagerFactoryBean.getJpaPropertyMap().putAll(this.environment.getSubProperties("properties."));
        this.configure(entityManagerFactoryBean);
        return entityManagerFactoryBean;
    }

    @Bean
    public JpaVendorAdapter jpaVendorAdapter() {
        AbstractJpaVendorAdapter adapter = this.createJpaVendorAdapter();
        adapter.setShowSql(((Boolean)this.environment.getProperty("show-sql", Boolean.class, (Object)true)).booleanValue());
        adapter.setDatabasePlatform(this.environment.getProperty("database-platform"));
        adapter.setDatabase((Database)this.environment.getProperty("database", Database.class, (Object)Database.DEFAULT));
        adapter.setGenerateDdl(((Boolean)this.environment.getProperty("generate-ddl", Boolean.class, (Object)false)).booleanValue());
        return adapter;
    }

    protected abstract AbstractJpaVendorAdapter createJpaVendorAdapter();

    protected DataSource getDataSource() {
        try {
            return (DataSource)this.beanFactory.getBean("dataSource", DataSource.class);
        }
        catch (RuntimeException ex) {
            return (DataSource)this.beanFactory.getBean(DataSource.class);
        }
    }

    protected String[] getPackagesToScan() {
        List<String> basePackages = AutoConfigurationUtils.getBasePackages((BeanFactory)this.beanFactory);
        Assert.notEmpty(basePackages, (String)"Unable to find JPA packages to scan, please define a @ComponentScan annotation or disable JpaAutoConfiguration");
        return basePackages.toArray(new String[basePackages.size()]);
    }

    protected void configure(LocalContainerEntityManagerFactoryBean entityManagerFactoryBean) {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnMissingBean(value={OpenEntityManagerInViewInterceptor.class, OpenEntityManagerInViewFilter.class})
    @ConditionalOnExpression(value="${spring.jpa.openInView:${spring.jpa.open_in_view:true}}")
    protected static class JpaWebConfiguration
    extends WebMvcConfigurerAdapter {
        protected JpaWebConfiguration() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addWebRequestInterceptor((WebRequestInterceptor)this.openEntityManagerInViewInterceptor());
        }

        @Bean
        public OpenEntityManagerInViewInterceptor openEntityManagerInViewInterceptor() {
            return new OpenEntityManagerInViewInterceptor();
        }
    }
}

