/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.autoconfigure.batch.BatchDatabaseInitializer;
import org.springframework.boot.autoconfigure.batch.JobExecutionExitCodeGenerator;
import org.springframework.boot.autoconfigure.batch.JobLauncherCommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={JobLauncher.class})
public class BatchAutoConfiguration {
    @Value(value="${spring.batch.job.name:}")
    private String jobName;

    @Bean
    @ConditionalOnMissingBean(value={BatchDatabaseInitializer.class})
    public BatchDatabaseInitializer batchDatabaseInitializer() {
        return new BatchDatabaseInitializer();
    }

    @Bean
    @ConditionalOnMissingBean(value={JobLauncherCommandLineRunner.class})
    @ConditionalOnBean(value={JobLauncher.class})
    @ConditionalOnExpression(value="${spring.batch.job.enabled:true}")
    public JobLauncherCommandLineRunner jobLauncherCommandLineRunner() {
        JobLauncherCommandLineRunner runner = new JobLauncherCommandLineRunner();
        if (StringUtils.hasText((String)this.jobName)) {
            runner.setJobName(this.jobName);
        }
        return runner;
    }

    @Bean
    @ConditionalOnMissingBean(value={ExitCodeGenerator.class})
    @ConditionalOnBean(value={JobLauncher.class})
    public ExitCodeGenerator jobExecutionExitCodeGenerator() {
        return new JobExecutionExitCodeGenerator();
    }
}

