/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class OnBeanCondition
extends SpringBootCondition
implements ConfigurationCondition {
    private static final String[] NO_BEANS = new String[0];

    OnBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List<String> matching;
        BeanSearchSpec spec;
        StringBuffer matchMessage = new StringBuffer();
        if (metadata.isAnnotated(ConditionalOnBean.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnBean.class);
            matching = this.getMatchingBeans(context, spec);
            if (matching.isEmpty()) {
                return ConditionOutcome.noMatch("@ConditionalOnBean " + spec + " found no beans");
            }
            matchMessage.append("@ConditionalOnBean " + spec + " found the following " + matching);
        }
        if (metadata.isAnnotated(ConditionalOnMissingBean.class.getName())) {
            spec = new BeanSearchSpec(context, metadata, ConditionalOnMissingBean.class);
            matching = this.getMatchingBeans(context, spec);
            if (!matching.isEmpty()) {
                return ConditionOutcome.noMatch("@ConditionalOnMissingBean " + spec + " found the following " + matching);
            }
            matchMessage.append(matchMessage.length() == 0 ? "" : " ");
            matchMessage.append("@ConditionalOnMissingBean " + spec + " found no beans");
        }
        return ConditionOutcome.match(matchMessage.toString());
    }

    private List<String> getMatchingBeans(ConditionContext context, BeanSearchSpec beans) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beans.getStrategy() == SearchStrategy.PARENTS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, (String)"Unable to use SearchStrategy.PARENTS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        ArrayList<String> beanNames = new ArrayList<String>();
        boolean considerHierarchy = beans.getStrategy() == SearchStrategy.ALL;
        for (String type : beans.getTypes()) {
            beanNames.addAll(Arrays.asList(this.getBeanNamesForType(beanFactory, type, context.getClassLoader(), considerHierarchy)));
        }
        for (String annotation : beans.getAnnotations()) {
            beanNames.addAll(Arrays.asList(this.getBeanNamesForAnnotation(beanFactory, annotation, context.getClassLoader(), considerHierarchy)));
        }
        for (String beanName : beans.getNames()) {
            if (!this.containsBean(beanFactory, beanName, considerHierarchy)) continue;
            beanNames.add(beanName);
        }
        return beanNames;
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private String[] getBeanNamesForType(ConfigurableListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        try {
            Class typeClass = ClassUtils.forName((String)type, (ClassLoader)classLoader);
            if (considerHierarchy) {
                return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, (Class)typeClass, (boolean)false, (boolean)false);
            }
            return beanFactory.getBeanNamesForType(typeClass, false, false);
        }
        catch (ClassNotFoundException ex) {
            return NO_BEANS;
        }
    }

    private String[] getBeanNamesForAnnotation(ConfigurableListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        String[] result = NO_BEANS;
        try {
            Class typeClass = ClassUtils.forName((String)type, (ClassLoader)classLoader);
            result = beanFactory.getBeanNamesForAnnotation(typeClass);
            if (considerHierarchy && beanFactory.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
                String[] parentResult = this.getBeanNamesForAnnotation((ConfigurableListableBeanFactory)beanFactory.getParentBeanFactory(), type, classLoader, true);
                ArrayList<String> resultList = new ArrayList<String>();
                resultList.addAll(Arrays.asList(result));
                for (String beanName : parentResult) {
                    if (resultList.contains(beanName) || beanFactory.containsLocalBean(beanName)) continue;
                    resultList.add(beanName);
                }
                result = StringUtils.toStringArray(resultList);
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            return NO_BEANS;
        }
    }

    private static class BeanSearchSpec {
        private List<String> names = new ArrayList<String>();
        private List<String> types = new ArrayList<String>();
        private List<String> annotations = new ArrayList<String>();
        private SearchStrategy strategy;

        public BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
            this.collect((MultiValueMap<String, Object>)attributes, "name", this.names);
            this.collect((MultiValueMap<String, Object>)attributes, "value", this.types);
            this.collect((MultiValueMap<String, Object>)attributes, "annotation", this.annotations);
            if (this.types.isEmpty() && this.names.isEmpty()) {
                this.addDeducedBeanType(context, metadata, this.types);
            }
            Assert.isTrue((!this.types.isEmpty() || !this.names.isEmpty() || !this.annotations.isEmpty() ? 1 : 0) != 0, (String)("@" + ClassUtils.getShortName(annotationType) + " annotations must specify at least one bean (type, name or annotation)"));
            this.strategy = (SearchStrategy)((Object)metadata.getAnnotationAttributes(annotationType.getName()).get("search"));
        }

        private void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            List valueList = (List)attributes.get((Object)key);
            Iterator i$ = valueList.iterator();
            while (i$.hasNext()) {
                String[] valueArray;
                for (String value : valueArray = (String[])i$.next()) {
                    destination.add(value);
                }
            }
        }

        private void addDeducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata, final List<String> beanTypes) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                try {
                    final MethodMetadata methodMetadata = (MethodMetadata)metadata;
                    Class configClass = ClassUtils.forName((String)methodMetadata.getDeclaringClassName(), (ClassLoader)context.getClassLoader());
                    ReflectionUtils.doWithMethods((Class)configClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                            if (methodMetadata.getMethodName().equals(method.getName())) {
                                beanTypes.add(method.getReturnType().getName());
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }

        public SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public String toString() {
            StringBuilder string = new StringBuilder();
            string.append("(");
            if (!this.names.isEmpty()) {
                string.append("names: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.names));
                if (!this.types.isEmpty()) {
                    string.append("; ");
                }
            }
            if (!this.types.isEmpty()) {
                string.append("types: ");
                string.append(StringUtils.collectionToCommaDelimitedString(this.types));
            }
            string.append("; SearchStrategy: ");
            string.append(this.strategy.toString().toLowerCase());
            string.append(")");
            return string.toString();
        }
    }
}

