/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.redis;

import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnClass(value={LettuceConnection.class, RedisOperations.class})
public class RedisAutoConfiguration {

    @ConfigurationProperties(name="spring.redis")
    public static class RedisProperties {
        private String host = "localhost";
        private String password;
        private int port = 6379;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={RedisProperties.class})
    protected static class RedisConfiguration {
        @Autowired
        private RedisProperties config;

        protected RedisConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
        RedisConnectionFactory redisConnectionFactory() throws UnknownHostException {
            LettuceConnectionFactory factory = new LettuceConnectionFactory(this.config.getHost(), this.config.getPort());
            if (this.config.getPassword() != null) {
                factory.setPassword(this.config.getPassword());
            }
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean(name={"redisTemplate"})
        RedisOperations<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
            RedisTemplate template = new RedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        @ConditionalOnMissingBean(value={StringRedisTemplate.class})
        StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
            StringRedisTemplate template = new StringRedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }
    }
}

