/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ConditionalOnClass(value={JdbcTemplate.class, PlatformTransactionManager.class})
public class DataSourceTransactionManagerAutoConfiguration
implements Ordered {
    @Autowired(required=false)
    private DataSource dataSource;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Bean
    @ConditionalOnMissingBean(name={"transactionManager"})
    @ConditionalOnBean(value={DataSource.class})
    public PlatformTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @ConditionalOnMissingBean(value={AbstractTransactionManagementConfiguration.class})
    @Configuration
    @EnableTransactionManagement
    protected static class TransactionManagementConfiguration {
        protected TransactionManagementConfiguration() {
        }
    }
}

