/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.elasticsearch;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.client.Client;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Client.class})
@EnableConfigurationProperties(value={ElasticsearchProperties.class})
public class ElasticsearchAutoConfiguration
implements DisposableBean {
    private static Log logger = LogFactory.getLog(ElasticsearchAutoConfiguration.class);
    @Autowired
    private ElasticsearchProperties properties;
    private Client client;

    @Bean
    public Client elasticsearchClient() {
        this.client = this.properties.createClient();
        return this.client;
    }

    public void destroy() throws Exception {
        block5: {
            if (this.client != null) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Closing Elasticsearch client");
                    }
                    if (this.client != null) {
                        this.client.close();
                    }
                }
                catch (Exception ex) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Object)"Error closing Elasticsearch client: ", (Throwable)ex);
                }
            }
        }
    }
}

