/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.elasticsearch;

import org.elasticsearch.client.Client;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.elasticsearch.client.NodeClientFactoryBean;
import org.springframework.data.elasticsearch.client.TransportClientFactoryBean;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.data.elasticsearch")
public class ElasticsearchProperties {
    private String clusterName = "elasticsearch";
    private String clusterNodes;
    private boolean local = true;

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterNodes() {
        return this.clusterNodes;
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public Client createClient() {
        try {
            return StringUtils.hasLength((String)this.clusterNodes) ? this.createTransportClient() : this.createNodeClient();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Client createNodeClient() throws Exception {
        NodeClientFactoryBean factory = new NodeClientFactoryBean(this.local);
        factory.setClusterName(this.clusterName);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    private Client createTransportClient() throws Exception {
        TransportClientFactoryBean factory = new TransportClientFactoryBean();
        factory.setClusterName(this.clusterName);
        factory.setClusterNodes(this.clusterNodes);
        factory.afterPropertiesSet();
        return factory.getObject();
    }
}

