/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@EnableConfigurationProperties(value={JpaProperties.class})
public abstract class JpaBaseConfiguration
implements BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;
    @Autowired
    private DataSource dataSource;
    @Autowired(required=false)
    private PersistenceUnitManager persistenceUnitManager;
    @Autowired
    private JpaProperties jpaProperties;

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public PlatformTransactionManager transactionManager() {
        return new JpaTransactionManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public JpaVendorAdapter jpaVendorAdapter() {
        AbstractJpaVendorAdapter adapter = this.createJpaVendorAdapter();
        adapter.setShowSql(this.jpaProperties.isShowSql());
        adapter.setDatabase(this.jpaProperties.getDatabase());
        adapter.setDatabasePlatform(this.jpaProperties.getDatabasePlatform());
        adapter.setGenerateDdl(this.jpaProperties.isGenerateDdl());
        return adapter;
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityManagerFactoryBuilder entityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter) {
        EntityManagerFactoryBuilder builder = new EntityManagerFactoryBuilder(jpaVendorAdapter, this.jpaProperties, this.persistenceUnitManager);
        builder.setCallback(this.getVendorCallback());
        return builder;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder factory) {
        return factory.dataSource(this.dataSource).packages(this.getPackagesToScan()).properties(this.getVendorProperties()).build();
    }

    protected abstract AbstractJpaVendorAdapter createJpaVendorAdapter();

    protected abstract Map<String, String> getVendorProperties();

    protected abstract EntityManagerFactoryBuilder.EntityManagerFactoryBeanCallback getVendorCallback();

    protected String[] getPackagesToScan() {
        List<String> basePackages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        return basePackages.toArray(new String[basePackages.size()]);
    }

    protected void configure(LocalContainerEntityManagerFactoryBean entityManagerFactoryBean) {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnMissingBean(value={OpenEntityManagerInViewInterceptor.class, OpenEntityManagerInViewFilter.class})
    @ConditionalOnExpression(value="${spring.jpa.openInView:${spring.jpa.open_in_view:true}}")
    protected static class JpaWebConfiguration
    extends WebMvcConfigurerAdapter {
        protected JpaWebConfiguration() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addWebRequestInterceptor((WebRequestInterceptor)this.openEntityManagerInViewInterceptor());
        }

        @Bean
        public OpenEntityManagerInViewInterceptor openEntityManagerInViewInterceptor() {
            return new OpenEntityManagerInViewInterceptor();
        }
    }
}

