/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.SpringNamingStrategy;
import org.springframework.orm.jpa.vendor.Database;

@ConfigurationProperties(prefix="spring.jpa")
public class JpaProperties {
    private static final Log logger = LogFactory.getLog(JpaProperties.class);
    private Map<String, String> properties = new HashMap<String, String>();
    private String databasePlatform;
    private Database database = Database.DEFAULT;
    private boolean generateDdl = false;
    private boolean showSql = false;
    private Hibernate hibernate = new Hibernate();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(String databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public boolean isGenerateDdl() {
        return this.generateDdl;
    }

    public void setGenerateDdl(boolean generateDdl) {
        this.generateDdl = generateDdl;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public Hibernate getHibernate() {
        return this.hibernate;
    }

    public void setHibernate(Hibernate hibernate) {
        this.hibernate = hibernate;
    }

    public Map<String, String> getInitialHibernateProperties(DataSource dataSource) {
        return this.hibernate.getAdditionalProperties(this.properties);
    }

    public Map<String, String> getHibernateProperties(DataSource dataSource) {
        return this.hibernate.getDeferredAdditionalProperties(this.properties, dataSource);
    }

    public static class Hibernate {
        private Class<?> namingStrategy;
        private static Class<?> DEFAULT_NAMING_STRATEGY = SpringNamingStrategy.class;
        private String ddlAuto;
        private boolean deferDdl = true;

        public Class<?> getNamingStrategy() {
            return this.namingStrategy;
        }

        public void setNamingStrategy(Class<?> namingStrategy) {
            this.namingStrategy = namingStrategy;
        }

        @Deprecated
        public void setNamingstrategy(Class<?> namingStrategy) {
            logger.warn((Object)"The property spring.jpa.namingstrategy has been renamed, please update your configuration to use naming-strategy");
            this.setNamingStrategy(namingStrategy);
        }

        public String getDdlAuto() {
            return this.ddlAuto;
        }

        public void setDeferDdl(boolean deferDdl) {
            this.deferDdl = deferDdl;
        }

        public boolean isDeferDdl() {
            return this.deferDdl;
        }

        private String getDeferredDdlAuto(Map<String, String> existing, DataSource dataSource) {
            String ddlAuto;
            if (!this.deferDdl) {
                return "none";
            }
            String string = ddlAuto = this.ddlAuto != null ? this.ddlAuto : this.getDefaultDdlAuto(dataSource);
            if (!this.isAlreadyProvided(existing, "hbm2ddl.auto") && !"none".equals(ddlAuto)) {
                return ddlAuto;
            }
            if (this.isAlreadyProvided(existing, "hbm2ddl.auto")) {
                return existing.get("hibernate.hbm2ddl.auto");
            }
            return "none";
        }

        public void setDdlAuto(String ddlAuto) {
            this.ddlAuto = ddlAuto;
        }

        private Map<String, String> getDeferredAdditionalProperties(Map<String, String> properties, DataSource dataSource) {
            Map<String, String> deferred = this.getAdditionalProperties(properties);
            deferred.put("hibernate.hbm2ddl.auto", this.getDeferredDdlAuto(properties, dataSource));
            return deferred;
        }

        private Map<String, String> getAdditionalProperties(Map<String, String> existing) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (!this.isAlreadyProvided(existing, "ejb.naming_strategy") && this.namingStrategy != null) {
                result.put("hibernate.ejb.naming_strategy", this.namingStrategy.getName());
            } else if (this.namingStrategy == null) {
                result.put("hibernate.ejb.naming_strategy", DEFAULT_NAMING_STRATEGY.getName());
            }
            if (this.deferDdl) {
                result.put("hibernate.hbm2ddl.auto", "none");
            } else {
                result.put("hibernate.hbm2ddl.auto", this.ddlAuto);
            }
            return result;
        }

        private boolean isAlreadyProvided(Map<String, String> existing, String key) {
            return existing.containsKey("hibernate." + key);
        }

        private String getDefaultDdlAuto(DataSource dataSource) {
            if (EmbeddedDatabaseConnection.isEmbedded(dataSource)) {
                return "create-drop";
            }
            return "none";
        }
    }
}

